/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetDevEndpointsRequest extends GlueRequest implements
        ToCopyableBuilder<BatchGetDevEndpointsRequest.Builder, BatchGetDevEndpointsRequest> {
    private static final SdkField<List<String>> DEV_ENDPOINT_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(BatchGetDevEndpointsRequest::devEndpointNames))
            .setter(setter(Builder::devEndpointNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DevEndpointNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEV_ENDPOINT_NAMES_FIELD));

    private final List<String> devEndpointNames;

    private BatchGetDevEndpointsRequest(BuilderImpl builder) {
        super(builder);
        this.devEndpointNames = builder.devEndpointNames;
    }

    /**
     * Returns true if the DevEndpointNames property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasDevEndpointNames() {
        return devEndpointNames != null && !(devEndpointNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of <code>DevEndpoint</code> names, which might be the names returned from the
     * <code>ListDevEndpoint</code> operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDevEndpointNames()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of <code>DevEndpoint</code> names, which might be the names returned from the
     *         <code>ListDevEndpoint</code> operation.
     */
    public List<String> devEndpointNames() {
        return devEndpointNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(devEndpointNames());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetDevEndpointsRequest)) {
            return false;
        }
        BatchGetDevEndpointsRequest other = (BatchGetDevEndpointsRequest) obj;
        return Objects.equals(devEndpointNames(), other.devEndpointNames());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BatchGetDevEndpointsRequest").add("DevEndpointNames", devEndpointNames()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DevEndpointNames":
            return Optional.ofNullable(clazz.cast(devEndpointNames()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetDevEndpointsRequest, T> g) {
        return obj -> g.apply((BatchGetDevEndpointsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueRequest.Builder, SdkPojo, CopyableBuilder<Builder, BatchGetDevEndpointsRequest> {
        /**
         * <p>
         * The list of <code>DevEndpoint</code> names, which might be the names returned from the
         * <code>ListDevEndpoint</code> operation.
         * </p>
         * 
         * @param devEndpointNames
         *        The list of <code>DevEndpoint</code> names, which might be the names returned from the
         *        <code>ListDevEndpoint</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder devEndpointNames(Collection<String> devEndpointNames);

        /**
         * <p>
         * The list of <code>DevEndpoint</code> names, which might be the names returned from the
         * <code>ListDevEndpoint</code> operation.
         * </p>
         * 
         * @param devEndpointNames
         *        The list of <code>DevEndpoint</code> names, which might be the names returned from the
         *        <code>ListDevEndpoint</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder devEndpointNames(String... devEndpointNames);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlueRequest.BuilderImpl implements Builder {
        private List<String> devEndpointNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetDevEndpointsRequest model) {
            super(model);
            devEndpointNames(model.devEndpointNames);
        }

        public final Collection<String> getDevEndpointNames() {
            return devEndpointNames;
        }

        @Override
        public final Builder devEndpointNames(Collection<String> devEndpointNames) {
            this.devEndpointNames = DevEndpointNamesCopier.copy(devEndpointNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder devEndpointNames(String... devEndpointNames) {
            devEndpointNames(Arrays.asList(devEndpointNames));
            return this;
        }

        public final void setDevEndpointNames(Collection<String> devEndpointNames) {
            this.devEndpointNames = DevEndpointNamesCopier.copy(devEndpointNames);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetDevEndpointsRequest build() {
            return new BatchGetDevEndpointsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
