/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.CodeGenNodeArg;
import software.amazon.awssdk.services.glue.model.CodeGenNodeArgsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CodeGenNode
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CodeGenNode> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CodeGenNode.getter(CodeGenNode::id)).setter(CodeGenNode.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> NODE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CodeGenNode.getter(CodeGenNode::nodeType)).setter(CodeGenNode.setter(Builder::nodeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeType").build()}).build();
    private static final SdkField<List<CodeGenNodeArg>> ARGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CodeGenNode.getter(CodeGenNode::args)).setter(CodeGenNode.setter(Builder::args)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Args").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CodeGenNodeArg::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> LINE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(CodeGenNode.getter(CodeGenNode::lineNumber)).setter(CodeGenNode.setter(Builder::lineNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LineNumber").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NODE_TYPE_FIELD, ARGS_FIELD, LINE_NUMBER_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String nodeType;
    private final List<CodeGenNodeArg> args;
    private final Integer lineNumber;

    private CodeGenNode(BuilderImpl builder) {
        this.id = builder.id;
        this.nodeType = builder.nodeType;
        this.args = builder.args;
        this.lineNumber = builder.lineNumber;
    }

    public String id() {
        return this.id;
    }

    public String nodeType() {
        return this.nodeType;
    }

    public boolean hasArgs() {
        return this.args != null && !(this.args instanceof SdkAutoConstructList);
    }

    public List<CodeGenNodeArg> args() {
        return this.args;
    }

    public Integer lineNumber() {
        return this.lineNumber;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeType());
        hashCode = 31 * hashCode + Objects.hashCode(this.args());
        hashCode = 31 * hashCode + Objects.hashCode(this.lineNumber());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeGenNode)) {
            return false;
        }
        CodeGenNode other = (CodeGenNode)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.nodeType(), other.nodeType()) && Objects.equals(this.args(), other.args()) && Objects.equals(this.lineNumber(), other.lineNumber());
    }

    public String toString() {
        return ToString.builder((String)"CodeGenNode").add("Id", (Object)this.id()).add("NodeType", (Object)this.nodeType()).add("Args", this.args()).add("LineNumber", (Object)this.lineNumber()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "NodeType": {
                return Optional.ofNullable(clazz.cast(this.nodeType()));
            }
            case "Args": {
                return Optional.ofNullable(clazz.cast(this.args()));
            }
            case "LineNumber": {
                return Optional.ofNullable(clazz.cast(this.lineNumber()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CodeGenNode, T> g) {
        return obj -> g.apply((CodeGenNode)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String nodeType;
        private List<CodeGenNodeArg> args = DefaultSdkAutoConstructList.getInstance();
        private Integer lineNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(CodeGenNode model) {
            this.id(model.id);
            this.nodeType(model.nodeType);
            this.args(model.args);
            this.lineNumber(model.lineNumber);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getNodeType() {
            return this.nodeType;
        }

        @Override
        public final Builder nodeType(String nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        public final void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }

        public final Collection<CodeGenNodeArg.Builder> getArgs() {
            return this.args != null ? (Collection)this.args.stream().map(CodeGenNodeArg::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder args(Collection<CodeGenNodeArg> args) {
            this.args = CodeGenNodeArgsCopier.copy(args);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder args(CodeGenNodeArg ... args) {
            this.args(Arrays.asList(args));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder args(Consumer<CodeGenNodeArg.Builder> ... args) {
            this.args(Stream.of(args).map(c -> (CodeGenNodeArg)((CodeGenNodeArg.Builder)CodeGenNodeArg.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setArgs(Collection<CodeGenNodeArg.BuilderImpl> args) {
            this.args = CodeGenNodeArgsCopier.copyFromBuilder(args);
        }

        public final Integer getLineNumber() {
            return this.lineNumber;
        }

        @Override
        public final Builder lineNumber(Integer lineNumber) {
            this.lineNumber = lineNumber;
            return this;
        }

        public final void setLineNumber(Integer lineNumber) {
            this.lineNumber = lineNumber;
        }

        public CodeGenNode build() {
            return new CodeGenNode(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CodeGenNode> {
        public Builder id(String var1);

        public Builder nodeType(String var1);

        public Builder args(Collection<CodeGenNodeArg> var1);

        public Builder args(CodeGenNodeArg ... var1);

        public Builder args(Consumer<CodeGenNodeArg.Builder> ... var1);

        public Builder lineNumber(Integer var1);
    }
}

