/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.EvaluationMetrics;
import software.amazon.awssdk.services.glue.model.GlueTable;
import software.amazon.awssdk.services.glue.model.GlueTablesCopier;
import software.amazon.awssdk.services.glue.model.SchemaColumn;
import software.amazon.awssdk.services.glue.model.TransformParameters;
import software.amazon.awssdk.services.glue.model.TransformSchemaCopier;
import software.amazon.awssdk.services.glue.model.TransformStatusType;
import software.amazon.awssdk.services.glue.model.WorkerType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MLTransform
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MLTransform> {
    private static final SdkField<String> TRANSFORM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MLTransform.getter(MLTransform::transformId)).setter(MLTransform.setter(Builder::transformId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransformId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MLTransform.getter(MLTransform::name)).setter(MLTransform.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MLTransform.getter(MLTransform::description)).setter(MLTransform.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MLTransform.getter(MLTransform::statusAsString)).setter(MLTransform.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> CREATED_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(MLTransform.getter(MLTransform::createdOn)).setter(MLTransform.setter(Builder::createdOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedOn").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(MLTransform.getter(MLTransform::lastModifiedOn)).setter(MLTransform.setter(Builder::lastModifiedOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedOn").build()}).build();
    private static final SdkField<List<GlueTable>> INPUT_RECORD_TABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(MLTransform.getter(MLTransform::inputRecordTables)).setter(MLTransform.setter(Builder::inputRecordTables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputRecordTables").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GlueTable::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<TransformParameters> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(MLTransform.getter(MLTransform::parameters)).setter(MLTransform.setter(Builder::parameters)).constructor(TransformParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build()}).build();
    private static final SdkField<EvaluationMetrics> EVALUATION_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(MLTransform.getter(MLTransform::evaluationMetrics)).setter(MLTransform.setter(Builder::evaluationMetrics)).constructor(EvaluationMetrics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationMetrics").build()}).build();
    private static final SdkField<Integer> LABEL_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(MLTransform.getter(MLTransform::labelCount)).setter(MLTransform.setter(Builder::labelCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelCount").build()}).build();
    private static final SdkField<List<SchemaColumn>> SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(MLTransform.getter(MLTransform::schema)).setter(MLTransform.setter(Builder::schema)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schema").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SchemaColumn::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MLTransform.getter(MLTransform::role)).setter(MLTransform.setter(Builder::role)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()}).build();
    private static final SdkField<String> GLUE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MLTransform.getter(MLTransform::glueVersion)).setter(MLTransform.setter(Builder::glueVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlueVersion").build()}).build();
    private static final SdkField<Double> MAX_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).getter(MLTransform.getter(MLTransform::maxCapacity)).setter(MLTransform.setter(Builder::maxCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxCapacity").build()}).build();
    private static final SdkField<String> WORKER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MLTransform.getter(MLTransform::workerTypeAsString)).setter(MLTransform.setter(Builder::workerType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkerType").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_WORKERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(MLTransform.getter(MLTransform::numberOfWorkers)).setter(MLTransform.setter(Builder::numberOfWorkers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfWorkers").build()}).build();
    private static final SdkField<Integer> TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(MLTransform.getter(MLTransform::timeout)).setter(MLTransform.setter(Builder::timeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timeout").build()}).build();
    private static final SdkField<Integer> MAX_RETRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(MLTransform.getter(MLTransform::maxRetries)).setter(MLTransform.setter(Builder::maxRetries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRetries").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSFORM_ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, STATUS_FIELD, CREATED_ON_FIELD, LAST_MODIFIED_ON_FIELD, INPUT_RECORD_TABLES_FIELD, PARAMETERS_FIELD, EVALUATION_METRICS_FIELD, LABEL_COUNT_FIELD, SCHEMA_FIELD, ROLE_FIELD, GLUE_VERSION_FIELD, MAX_CAPACITY_FIELD, WORKER_TYPE_FIELD, NUMBER_OF_WORKERS_FIELD, TIMEOUT_FIELD, MAX_RETRIES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String transformId;
    private final String name;
    private final String description;
    private final String status;
    private final Instant createdOn;
    private final Instant lastModifiedOn;
    private final List<GlueTable> inputRecordTables;
    private final TransformParameters parameters;
    private final EvaluationMetrics evaluationMetrics;
    private final Integer labelCount;
    private final List<SchemaColumn> schema;
    private final String role;
    private final String glueVersion;
    private final Double maxCapacity;
    private final String workerType;
    private final Integer numberOfWorkers;
    private final Integer timeout;
    private final Integer maxRetries;

    private MLTransform(BuilderImpl builder) {
        this.transformId = builder.transformId;
        this.name = builder.name;
        this.description = builder.description;
        this.status = builder.status;
        this.createdOn = builder.createdOn;
        this.lastModifiedOn = builder.lastModifiedOn;
        this.inputRecordTables = builder.inputRecordTables;
        this.parameters = builder.parameters;
        this.evaluationMetrics = builder.evaluationMetrics;
        this.labelCount = builder.labelCount;
        this.schema = builder.schema;
        this.role = builder.role;
        this.glueVersion = builder.glueVersion;
        this.maxCapacity = builder.maxCapacity;
        this.workerType = builder.workerType;
        this.numberOfWorkers = builder.numberOfWorkers;
        this.timeout = builder.timeout;
        this.maxRetries = builder.maxRetries;
    }

    public String transformId() {
        return this.transformId;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public TransformStatusType status() {
        return TransformStatusType.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Instant createdOn() {
        return this.createdOn;
    }

    public Instant lastModifiedOn() {
        return this.lastModifiedOn;
    }

    public List<GlueTable> inputRecordTables() {
        return this.inputRecordTables;
    }

    public TransformParameters parameters() {
        return this.parameters;
    }

    public EvaluationMetrics evaluationMetrics() {
        return this.evaluationMetrics;
    }

    public Integer labelCount() {
        return this.labelCount;
    }

    public List<SchemaColumn> schema() {
        return this.schema;
    }

    public String role() {
        return this.role;
    }

    public String glueVersion() {
        return this.glueVersion;
    }

    public Double maxCapacity() {
        return this.maxCapacity;
    }

    public WorkerType workerType() {
        return WorkerType.fromValue(this.workerType);
    }

    public String workerTypeAsString() {
        return this.workerType;
    }

    public Integer numberOfWorkers() {
        return this.numberOfWorkers;
    }

    public Integer timeout() {
        return this.timeout;
    }

    public Integer maxRetries() {
        return this.maxRetries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.transformId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdOn());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedOn());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputRecordTables());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationMetrics());
        hashCode = 31 * hashCode + Objects.hashCode(this.labelCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.schema());
        hashCode = 31 * hashCode + Objects.hashCode(this.role());
        hashCode = 31 * hashCode + Objects.hashCode(this.glueVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.workerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfWorkers());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxRetries());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MLTransform)) {
            return false;
        }
        MLTransform other = (MLTransform)obj;
        return Objects.equals(this.transformId(), other.transformId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.createdOn(), other.createdOn()) && Objects.equals(this.lastModifiedOn(), other.lastModifiedOn()) && Objects.equals(this.inputRecordTables(), other.inputRecordTables()) && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.evaluationMetrics(), other.evaluationMetrics()) && Objects.equals(this.labelCount(), other.labelCount()) && Objects.equals(this.schema(), other.schema()) && Objects.equals(this.role(), other.role()) && Objects.equals(this.glueVersion(), other.glueVersion()) && Objects.equals(this.maxCapacity(), other.maxCapacity()) && Objects.equals(this.workerTypeAsString(), other.workerTypeAsString()) && Objects.equals(this.numberOfWorkers(), other.numberOfWorkers()) && Objects.equals(this.timeout(), other.timeout()) && Objects.equals(this.maxRetries(), other.maxRetries());
    }

    public String toString() {
        return ToString.builder((String)"MLTransform").add("TransformId", (Object)this.transformId()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Status", (Object)this.statusAsString()).add("CreatedOn", (Object)this.createdOn()).add("LastModifiedOn", (Object)this.lastModifiedOn()).add("InputRecordTables", this.inputRecordTables()).add("Parameters", (Object)this.parameters()).add("EvaluationMetrics", (Object)this.evaluationMetrics()).add("LabelCount", (Object)this.labelCount()).add("Schema", this.schema()).add("Role", (Object)this.role()).add("GlueVersion", (Object)this.glueVersion()).add("MaxCapacity", (Object)this.maxCapacity()).add("WorkerType", (Object)this.workerTypeAsString()).add("NumberOfWorkers", (Object)this.numberOfWorkers()).add("Timeout", (Object)this.timeout()).add("MaxRetries", (Object)this.maxRetries()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TransformId": {
                return Optional.ofNullable(clazz.cast(this.transformId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "CreatedOn": {
                return Optional.ofNullable(clazz.cast(this.createdOn()));
            }
            case "LastModifiedOn": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedOn()));
            }
            case "InputRecordTables": {
                return Optional.ofNullable(clazz.cast(this.inputRecordTables()));
            }
            case "Parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "EvaluationMetrics": {
                return Optional.ofNullable(clazz.cast(this.evaluationMetrics()));
            }
            case "LabelCount": {
                return Optional.ofNullable(clazz.cast(this.labelCount()));
            }
            case "Schema": {
                return Optional.ofNullable(clazz.cast(this.schema()));
            }
            case "Role": {
                return Optional.ofNullable(clazz.cast(this.role()));
            }
            case "GlueVersion": {
                return Optional.ofNullable(clazz.cast(this.glueVersion()));
            }
            case "MaxCapacity": {
                return Optional.ofNullable(clazz.cast(this.maxCapacity()));
            }
            case "WorkerType": {
                return Optional.ofNullable(clazz.cast(this.workerTypeAsString()));
            }
            case "NumberOfWorkers": {
                return Optional.ofNullable(clazz.cast(this.numberOfWorkers()));
            }
            case "Timeout": {
                return Optional.ofNullable(clazz.cast(this.timeout()));
            }
            case "MaxRetries": {
                return Optional.ofNullable(clazz.cast(this.maxRetries()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MLTransform, T> g) {
        return obj -> g.apply((MLTransform)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String transformId;
        private String name;
        private String description;
        private String status;
        private Instant createdOn;
        private Instant lastModifiedOn;
        private List<GlueTable> inputRecordTables = DefaultSdkAutoConstructList.getInstance();
        private TransformParameters parameters;
        private EvaluationMetrics evaluationMetrics;
        private Integer labelCount;
        private List<SchemaColumn> schema = DefaultSdkAutoConstructList.getInstance();
        private String role;
        private String glueVersion;
        private Double maxCapacity;
        private String workerType;
        private Integer numberOfWorkers;
        private Integer timeout;
        private Integer maxRetries;

        private BuilderImpl() {
        }

        private BuilderImpl(MLTransform model) {
            this.transformId(model.transformId);
            this.name(model.name);
            this.description(model.description);
            this.status(model.status);
            this.createdOn(model.createdOn);
            this.lastModifiedOn(model.lastModifiedOn);
            this.inputRecordTables(model.inputRecordTables);
            this.parameters(model.parameters);
            this.evaluationMetrics(model.evaluationMetrics);
            this.labelCount(model.labelCount);
            this.schema(model.schema);
            this.role(model.role);
            this.glueVersion(model.glueVersion);
            this.maxCapacity(model.maxCapacity);
            this.workerType(model.workerType);
            this.numberOfWorkers(model.numberOfWorkers);
            this.timeout(model.timeout);
            this.maxRetries(model.maxRetries);
        }

        public final String getTransformId() {
            return this.transformId;
        }

        @Override
        public final Builder transformId(String transformId) {
            this.transformId = transformId;
            return this;
        }

        public final void setTransformId(String transformId) {
            this.transformId = transformId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getStatusAsString() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TransformStatusType status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getCreatedOn() {
            return this.createdOn;
        }

        @Override
        public final Builder createdOn(Instant createdOn) {
            this.createdOn = createdOn;
            return this;
        }

        public final void setCreatedOn(Instant createdOn) {
            this.createdOn = createdOn;
        }

        public final Instant getLastModifiedOn() {
            return this.lastModifiedOn;
        }

        @Override
        public final Builder lastModifiedOn(Instant lastModifiedOn) {
            this.lastModifiedOn = lastModifiedOn;
            return this;
        }

        public final void setLastModifiedOn(Instant lastModifiedOn) {
            this.lastModifiedOn = lastModifiedOn;
        }

        public final Collection<GlueTable.Builder> getInputRecordTables() {
            return this.inputRecordTables != null ? (Collection)this.inputRecordTables.stream().map(GlueTable::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder inputRecordTables(Collection<GlueTable> inputRecordTables) {
            this.inputRecordTables = GlueTablesCopier.copy(inputRecordTables);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputRecordTables(GlueTable ... inputRecordTables) {
            this.inputRecordTables(Arrays.asList(inputRecordTables));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputRecordTables(Consumer<GlueTable.Builder> ... inputRecordTables) {
            this.inputRecordTables(Stream.of(inputRecordTables).map(c -> (GlueTable)((GlueTable.Builder)GlueTable.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInputRecordTables(Collection<GlueTable.BuilderImpl> inputRecordTables) {
            this.inputRecordTables = GlueTablesCopier.copyFromBuilder(inputRecordTables);
        }

        public final TransformParameters.Builder getParameters() {
            return this.parameters != null ? this.parameters.toBuilder() : null;
        }

        @Override
        public final Builder parameters(TransformParameters parameters) {
            this.parameters = parameters;
            return this;
        }

        public final void setParameters(TransformParameters.BuilderImpl parameters) {
            this.parameters = parameters != null ? parameters.build() : null;
        }

        public final EvaluationMetrics.Builder getEvaluationMetrics() {
            return this.evaluationMetrics != null ? this.evaluationMetrics.toBuilder() : null;
        }

        @Override
        public final Builder evaluationMetrics(EvaluationMetrics evaluationMetrics) {
            this.evaluationMetrics = evaluationMetrics;
            return this;
        }

        public final void setEvaluationMetrics(EvaluationMetrics.BuilderImpl evaluationMetrics) {
            this.evaluationMetrics = evaluationMetrics != null ? evaluationMetrics.build() : null;
        }

        public final Integer getLabelCount() {
            return this.labelCount;
        }

        @Override
        public final Builder labelCount(Integer labelCount) {
            this.labelCount = labelCount;
            return this;
        }

        public final void setLabelCount(Integer labelCount) {
            this.labelCount = labelCount;
        }

        public final Collection<SchemaColumn.Builder> getSchema() {
            return this.schema != null ? (Collection)this.schema.stream().map(SchemaColumn::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder schema(Collection<SchemaColumn> schema) {
            this.schema = TransformSchemaCopier.copy(schema);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schema(SchemaColumn ... schema) {
            this.schema(Arrays.asList(schema));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schema(Consumer<SchemaColumn.Builder> ... schema) {
            this.schema(Stream.of(schema).map(c -> (SchemaColumn)((SchemaColumn.Builder)SchemaColumn.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSchema(Collection<SchemaColumn.BuilderImpl> schema) {
            this.schema = TransformSchemaCopier.copyFromBuilder(schema);
        }

        public final String getRole() {
            return this.role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        public final String getGlueVersion() {
            return this.glueVersion;
        }

        @Override
        public final Builder glueVersion(String glueVersion) {
            this.glueVersion = glueVersion;
            return this;
        }

        public final void setGlueVersion(String glueVersion) {
            this.glueVersion = glueVersion;
        }

        public final Double getMaxCapacity() {
            return this.maxCapacity;
        }

        @Override
        public final Builder maxCapacity(Double maxCapacity) {
            this.maxCapacity = maxCapacity;
            return this;
        }

        public final void setMaxCapacity(Double maxCapacity) {
            this.maxCapacity = maxCapacity;
        }

        public final String getWorkerTypeAsString() {
            return this.workerType;
        }

        @Override
        public final Builder workerType(String workerType) {
            this.workerType = workerType;
            return this;
        }

        @Override
        public final Builder workerType(WorkerType workerType) {
            this.workerType(workerType == null ? null : workerType.toString());
            return this;
        }

        public final void setWorkerType(String workerType) {
            this.workerType = workerType;
        }

        public final Integer getNumberOfWorkers() {
            return this.numberOfWorkers;
        }

        @Override
        public final Builder numberOfWorkers(Integer numberOfWorkers) {
            this.numberOfWorkers = numberOfWorkers;
            return this;
        }

        public final void setNumberOfWorkers(Integer numberOfWorkers) {
            this.numberOfWorkers = numberOfWorkers;
        }

        public final Integer getTimeout() {
            return this.timeout;
        }

        @Override
        public final Builder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public final void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        public final Integer getMaxRetries() {
            return this.maxRetries;
        }

        @Override
        public final Builder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public final void setMaxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
        }

        public MLTransform build() {
            return new MLTransform(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MLTransform> {
        public Builder transformId(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder status(String var1);

        public Builder status(TransformStatusType var1);

        public Builder createdOn(Instant var1);

        public Builder lastModifiedOn(Instant var1);

        public Builder inputRecordTables(Collection<GlueTable> var1);

        public Builder inputRecordTables(GlueTable ... var1);

        public Builder inputRecordTables(Consumer<GlueTable.Builder> ... var1);

        public Builder parameters(TransformParameters var1);

        default public Builder parameters(Consumer<TransformParameters.Builder> parameters) {
            return this.parameters((TransformParameters)((TransformParameters.Builder)TransformParameters.builder().applyMutation(parameters)).build());
        }

        public Builder evaluationMetrics(EvaluationMetrics var1);

        default public Builder evaluationMetrics(Consumer<EvaluationMetrics.Builder> evaluationMetrics) {
            return this.evaluationMetrics((EvaluationMetrics)((EvaluationMetrics.Builder)EvaluationMetrics.builder().applyMutation(evaluationMetrics)).build());
        }

        public Builder labelCount(Integer var1);

        public Builder schema(Collection<SchemaColumn> var1);

        public Builder schema(SchemaColumn ... var1);

        public Builder schema(Consumer<SchemaColumn.Builder> ... var1);

        public Builder role(String var1);

        public Builder glueVersion(String var1);

        public Builder maxCapacity(Double var1);

        public Builder workerType(String var1);

        public Builder workerType(WorkerType var1);

        public Builder numberOfWorkers(Integer var1);

        public Builder timeout(Integer var1);

        public Builder maxRetries(Integer var1);
    }
}

