/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.SchemaColumn;
import software.amazon.awssdk.services.glue.model.TransformSchemaCopier;
import software.amazon.awssdk.services.glue.model.TransformStatusType;
import software.amazon.awssdk.services.glue.model.TransformType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TransformFilterCriteria
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TransformFilterCriteria> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TransformFilterCriteria.getter(TransformFilterCriteria::name)).setter(TransformFilterCriteria.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> TRANSFORM_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TransformFilterCriteria.getter(TransformFilterCriteria::transformTypeAsString)).setter(TransformFilterCriteria.setter(Builder::transformType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransformType").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TransformFilterCriteria.getter(TransformFilterCriteria::statusAsString)).setter(TransformFilterCriteria.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> GLUE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TransformFilterCriteria.getter(TransformFilterCriteria::glueVersion)).setter(TransformFilterCriteria.setter(Builder::glueVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlueVersion").build()}).build();
    private static final SdkField<Instant> CREATED_BEFORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(TransformFilterCriteria.getter(TransformFilterCriteria::createdBefore)).setter(TransformFilterCriteria.setter(Builder::createdBefore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBefore").build()}).build();
    private static final SdkField<Instant> CREATED_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(TransformFilterCriteria.getter(TransformFilterCriteria::createdAfter)).setter(TransformFilterCriteria.setter(Builder::createdAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAfter").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_BEFORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(TransformFilterCriteria.getter(TransformFilterCriteria::lastModifiedBefore)).setter(TransformFilterCriteria.setter(Builder::lastModifiedBefore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedBefore").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(TransformFilterCriteria.getter(TransformFilterCriteria::lastModifiedAfter)).setter(TransformFilterCriteria.setter(Builder::lastModifiedAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedAfter").build()}).build();
    private static final SdkField<List<SchemaColumn>> SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(TransformFilterCriteria.getter(TransformFilterCriteria::schema)).setter(TransformFilterCriteria.setter(Builder::schema)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schema").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SchemaColumn::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TRANSFORM_TYPE_FIELD, STATUS_FIELD, GLUE_VERSION_FIELD, CREATED_BEFORE_FIELD, CREATED_AFTER_FIELD, LAST_MODIFIED_BEFORE_FIELD, LAST_MODIFIED_AFTER_FIELD, SCHEMA_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String transformType;
    private final String status;
    private final String glueVersion;
    private final Instant createdBefore;
    private final Instant createdAfter;
    private final Instant lastModifiedBefore;
    private final Instant lastModifiedAfter;
    private final List<SchemaColumn> schema;

    private TransformFilterCriteria(BuilderImpl builder) {
        this.name = builder.name;
        this.transformType = builder.transformType;
        this.status = builder.status;
        this.glueVersion = builder.glueVersion;
        this.createdBefore = builder.createdBefore;
        this.createdAfter = builder.createdAfter;
        this.lastModifiedBefore = builder.lastModifiedBefore;
        this.lastModifiedAfter = builder.lastModifiedAfter;
        this.schema = builder.schema;
    }

    public String name() {
        return this.name;
    }

    public TransformType transformType() {
        return TransformType.fromValue(this.transformType);
    }

    public String transformTypeAsString() {
        return this.transformType;
    }

    public TransformStatusType status() {
        return TransformStatusType.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public String glueVersion() {
        return this.glueVersion;
    }

    public Instant createdBefore() {
        return this.createdBefore;
    }

    public Instant createdAfter() {
        return this.createdAfter;
    }

    public Instant lastModifiedBefore() {
        return this.lastModifiedBefore;
    }

    public Instant lastModifiedAfter() {
        return this.lastModifiedAfter;
    }

    public List<SchemaColumn> schema() {
        return this.schema;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.transformTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.glueVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBefore());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAfter());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedBefore());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedAfter());
        hashCode = 31 * hashCode + Objects.hashCode(this.schema());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransformFilterCriteria)) {
            return false;
        }
        TransformFilterCriteria other = (TransformFilterCriteria)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.transformTypeAsString(), other.transformTypeAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.glueVersion(), other.glueVersion()) && Objects.equals(this.createdBefore(), other.createdBefore()) && Objects.equals(this.createdAfter(), other.createdAfter()) && Objects.equals(this.lastModifiedBefore(), other.lastModifiedBefore()) && Objects.equals(this.lastModifiedAfter(), other.lastModifiedAfter()) && Objects.equals(this.schema(), other.schema());
    }

    public String toString() {
        return ToString.builder((String)"TransformFilterCriteria").add("Name", (Object)this.name()).add("TransformType", (Object)this.transformTypeAsString()).add("Status", (Object)this.statusAsString()).add("GlueVersion", (Object)this.glueVersion()).add("CreatedBefore", (Object)this.createdBefore()).add("CreatedAfter", (Object)this.createdAfter()).add("LastModifiedBefore", (Object)this.lastModifiedBefore()).add("LastModifiedAfter", (Object)this.lastModifiedAfter()).add("Schema", this.schema()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "TransformType": {
                return Optional.ofNullable(clazz.cast(this.transformTypeAsString()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "GlueVersion": {
                return Optional.ofNullable(clazz.cast(this.glueVersion()));
            }
            case "CreatedBefore": {
                return Optional.ofNullable(clazz.cast(this.createdBefore()));
            }
            case "CreatedAfter": {
                return Optional.ofNullable(clazz.cast(this.createdAfter()));
            }
            case "LastModifiedBefore": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedBefore()));
            }
            case "LastModifiedAfter": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedAfter()));
            }
            case "Schema": {
                return Optional.ofNullable(clazz.cast(this.schema()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TransformFilterCriteria, T> g) {
        return obj -> g.apply((TransformFilterCriteria)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String transformType;
        private String status;
        private String glueVersion;
        private Instant createdBefore;
        private Instant createdAfter;
        private Instant lastModifiedBefore;
        private Instant lastModifiedAfter;
        private List<SchemaColumn> schema = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TransformFilterCriteria model) {
            this.name(model.name);
            this.transformType(model.transformType);
            this.status(model.status);
            this.glueVersion(model.glueVersion);
            this.createdBefore(model.createdBefore);
            this.createdAfter(model.createdAfter);
            this.lastModifiedBefore(model.lastModifiedBefore);
            this.lastModifiedAfter(model.lastModifiedAfter);
            this.schema(model.schema);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getTransformTypeAsString() {
            return this.transformType;
        }

        @Override
        public final Builder transformType(String transformType) {
            this.transformType = transformType;
            return this;
        }

        @Override
        public final Builder transformType(TransformType transformType) {
            this.transformType(transformType == null ? null : transformType.toString());
            return this;
        }

        public final void setTransformType(String transformType) {
            this.transformType = transformType;
        }

        public final String getStatusAsString() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TransformStatusType status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getGlueVersion() {
            return this.glueVersion;
        }

        @Override
        public final Builder glueVersion(String glueVersion) {
            this.glueVersion = glueVersion;
            return this;
        }

        public final void setGlueVersion(String glueVersion) {
            this.glueVersion = glueVersion;
        }

        public final Instant getCreatedBefore() {
            return this.createdBefore;
        }

        @Override
        public final Builder createdBefore(Instant createdBefore) {
            this.createdBefore = createdBefore;
            return this;
        }

        public final void setCreatedBefore(Instant createdBefore) {
            this.createdBefore = createdBefore;
        }

        public final Instant getCreatedAfter() {
            return this.createdAfter;
        }

        @Override
        public final Builder createdAfter(Instant createdAfter) {
            this.createdAfter = createdAfter;
            return this;
        }

        public final void setCreatedAfter(Instant createdAfter) {
            this.createdAfter = createdAfter;
        }

        public final Instant getLastModifiedBefore() {
            return this.lastModifiedBefore;
        }

        @Override
        public final Builder lastModifiedBefore(Instant lastModifiedBefore) {
            this.lastModifiedBefore = lastModifiedBefore;
            return this;
        }

        public final void setLastModifiedBefore(Instant lastModifiedBefore) {
            this.lastModifiedBefore = lastModifiedBefore;
        }

        public final Instant getLastModifiedAfter() {
            return this.lastModifiedAfter;
        }

        @Override
        public final Builder lastModifiedAfter(Instant lastModifiedAfter) {
            this.lastModifiedAfter = lastModifiedAfter;
            return this;
        }

        public final void setLastModifiedAfter(Instant lastModifiedAfter) {
            this.lastModifiedAfter = lastModifiedAfter;
        }

        public final Collection<SchemaColumn.Builder> getSchema() {
            return this.schema != null ? (Collection)this.schema.stream().map(SchemaColumn::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder schema(Collection<SchemaColumn> schema) {
            this.schema = TransformSchemaCopier.copy(schema);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schema(SchemaColumn ... schema) {
            this.schema(Arrays.asList(schema));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schema(Consumer<SchemaColumn.Builder> ... schema) {
            this.schema(Stream.of(schema).map(c -> (SchemaColumn)((SchemaColumn.Builder)SchemaColumn.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSchema(Collection<SchemaColumn.BuilderImpl> schema) {
            this.schema = TransformSchemaCopier.copyFromBuilder(schema);
        }

        public TransformFilterCriteria build() {
            return new TransformFilterCriteria(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TransformFilterCriteria> {
        public Builder name(String var1);

        public Builder transformType(String var1);

        public Builder transformType(TransformType var1);

        public Builder status(String var1);

        public Builder status(TransformStatusType var1);

        public Builder glueVersion(String var1);

        public Builder createdBefore(Instant var1);

        public Builder createdAfter(Instant var1);

        public Builder lastModifiedBefore(Instant var1);

        public Builder lastModifiedAfter(Instant var1);

        public Builder schema(Collection<SchemaColumn> var1);

        public Builder schema(SchemaColumn ... var1);

        public Builder schema(Consumer<SchemaColumn.Builder> ... var1);
    }
}

