/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.GrokClassifier;
import software.amazon.awssdk.services.glue.model.JsonClassifier;
import software.amazon.awssdk.services.glue.model.XMLClassifier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Classifier
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Classifier> {
    private static final SdkField<GrokClassifier> GROK_CLASSIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Classifier.getter(Classifier::grokClassifier)).setter(Classifier.setter(Builder::grokClassifier)).constructor(GrokClassifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrokClassifier").build()}).build();
    private static final SdkField<XMLClassifier> XML_CLASSIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Classifier.getter(Classifier::xmlClassifier)).setter(Classifier.setter(Builder::xmlClassifier)).constructor(XMLClassifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("XMLClassifier").build()}).build();
    private static final SdkField<JsonClassifier> JSON_CLASSIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Classifier.getter(Classifier::jsonClassifier)).setter(Classifier.setter(Builder::jsonClassifier)).constructor(JsonClassifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JsonClassifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROK_CLASSIFIER_FIELD, XML_CLASSIFIER_FIELD, JSON_CLASSIFIER_FIELD));
    private static final long serialVersionUID = 1L;
    private final GrokClassifier grokClassifier;
    private final XMLClassifier xmlClassifier;
    private final JsonClassifier jsonClassifier;

    private Classifier(BuilderImpl builder) {
        this.grokClassifier = builder.grokClassifier;
        this.xmlClassifier = builder.xmlClassifier;
        this.jsonClassifier = builder.jsonClassifier;
    }

    public GrokClassifier grokClassifier() {
        return this.grokClassifier;
    }

    public XMLClassifier xmlClassifier() {
        return this.xmlClassifier;
    }

    public JsonClassifier jsonClassifier() {
        return this.jsonClassifier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.grokClassifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.xmlClassifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.jsonClassifier());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Classifier)) {
            return false;
        }
        Classifier other = (Classifier)obj;
        return Objects.equals(this.grokClassifier(), other.grokClassifier()) && Objects.equals(this.xmlClassifier(), other.xmlClassifier()) && Objects.equals(this.jsonClassifier(), other.jsonClassifier());
    }

    public String toString() {
        return ToString.builder((String)"Classifier").add("GrokClassifier", (Object)this.grokClassifier()).add("XMLClassifier", (Object)this.xmlClassifier()).add("JsonClassifier", (Object)this.jsonClassifier()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GrokClassifier": {
                return Optional.ofNullable(clazz.cast(this.grokClassifier()));
            }
            case "XMLClassifier": {
                return Optional.ofNullable(clazz.cast(this.xmlClassifier()));
            }
            case "JsonClassifier": {
                return Optional.ofNullable(clazz.cast(this.jsonClassifier()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Classifier, T> g) {
        return obj -> g.apply((Classifier)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private GrokClassifier grokClassifier;
        private XMLClassifier xmlClassifier;
        private JsonClassifier jsonClassifier;

        private BuilderImpl() {
        }

        private BuilderImpl(Classifier model) {
            this.grokClassifier(model.grokClassifier);
            this.xmlClassifier(model.xmlClassifier);
            this.jsonClassifier(model.jsonClassifier);
        }

        public final GrokClassifier.Builder getGrokClassifier() {
            return this.grokClassifier != null ? this.grokClassifier.toBuilder() : null;
        }

        @Override
        public final Builder grokClassifier(GrokClassifier grokClassifier) {
            this.grokClassifier = grokClassifier;
            return this;
        }

        public final void setGrokClassifier(GrokClassifier.BuilderImpl grokClassifier) {
            this.grokClassifier = grokClassifier != null ? grokClassifier.build() : null;
        }

        public final XMLClassifier.Builder getXMLClassifier() {
            return this.xmlClassifier != null ? this.xmlClassifier.toBuilder() : null;
        }

        @Override
        public final Builder xmlClassifier(XMLClassifier xmlClassifier) {
            this.xmlClassifier = xmlClassifier;
            return this;
        }

        public final void setXMLClassifier(XMLClassifier.BuilderImpl xmlClassifier) {
            this.xmlClassifier = xmlClassifier != null ? xmlClassifier.build() : null;
        }

        public final JsonClassifier.Builder getJsonClassifier() {
            return this.jsonClassifier != null ? this.jsonClassifier.toBuilder() : null;
        }

        @Override
        public final Builder jsonClassifier(JsonClassifier jsonClassifier) {
            this.jsonClassifier = jsonClassifier;
            return this;
        }

        public final void setJsonClassifier(JsonClassifier.BuilderImpl jsonClassifier) {
            this.jsonClassifier = jsonClassifier != null ? jsonClassifier.build() : null;
        }

        public Classifier build() {
            return new Classifier(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Classifier> {
        public Builder grokClassifier(GrokClassifier var1);

        default public Builder grokClassifier(Consumer<GrokClassifier.Builder> grokClassifier) {
            return this.grokClassifier((GrokClassifier)((GrokClassifier.Builder)GrokClassifier.builder().applyMutation(grokClassifier)).build());
        }

        public Builder xmlClassifier(XMLClassifier var1);

        default public Builder xmlClassifier(Consumer<XMLClassifier.Builder> xmlClassifier) {
            return this.xmlClassifier((XMLClassifier)((XMLClassifier.Builder)XMLClassifier.builder().applyMutation(xmlClassifier)).build());
        }

        public Builder jsonClassifier(JsonClassifier var1);

        default public Builder jsonClassifier(Consumer<JsonClassifier.Builder> jsonClassifier) {
            return this.jsonClassifier((JsonClassifier)((JsonClassifier.Builder)JsonClassifier.builder().applyMutation(jsonClassifier)).build());
        }
    }
}

