/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glue.model.UserDefinedFunction;

@SdkInternalApi
public class UserDefinedFunctionMarshaller {
    private static final MarshallingInfo<String> FUNCTIONNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FunctionName").build();
    private static final MarshallingInfo<String> CLASSNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClassName").build();
    private static final MarshallingInfo<String> OWNERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OwnerName").build();
    private static final MarshallingInfo<String> OWNERTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OwnerType").build();
    private static final MarshallingInfo<Instant> CREATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreateTime").build();
    private static final MarshallingInfo<List> RESOURCEURIS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceUris").build();
    private static final UserDefinedFunctionMarshaller INSTANCE = new UserDefinedFunctionMarshaller();

    public static UserDefinedFunctionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(UserDefinedFunction userDefinedFunction, ProtocolMarshaller protocolMarshaller) {
        if (userDefinedFunction == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)userDefinedFunction.functionName(), FUNCTIONNAME_BINDING);
            protocolMarshaller.marshall((Object)userDefinedFunction.className(), CLASSNAME_BINDING);
            protocolMarshaller.marshall((Object)userDefinedFunction.ownerName(), OWNERNAME_BINDING);
            protocolMarshaller.marshall((Object)userDefinedFunction.ownerTypeString(), OWNERTYPE_BINDING);
            protocolMarshaller.marshall((Object)userDefinedFunction.createTime(), CREATETIME_BINDING);
            protocolMarshaller.marshall(userDefinedFunction.resourceUris(), RESOURCEURIS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

