/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.MapUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.glue.model.TableInput;
import software.amazon.awssdk.services.glue.transform.ColumnUnmarshaller;
import software.amazon.awssdk.services.glue.transform.StorageDescriptorUnmarshaller;

public class TableInputUnmarshaller
implements Unmarshaller<TableInput, JsonUnmarshallerContext> {
    private static final TableInputUnmarshaller INSTANCE = new TableInputUnmarshaller();

    public TableInput unmarshall(JsonUnmarshallerContext context) throws Exception {
        TableInput.Builder tableInputBuilder = TableInput.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    tableInputBuilder.name((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Description", targetDepth)) {
                    context.nextToken();
                    tableInputBuilder.description((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Owner", targetDepth)) {
                    context.nextToken();
                    tableInputBuilder.owner((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("LastAccessTime", targetDepth)) {
                    context.nextToken();
                    tableInputBuilder.lastAccessTime((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("LastAnalyzedTime", targetDepth)) {
                    context.nextToken();
                    tableInputBuilder.lastAnalyzedTime((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("Retention", targetDepth)) {
                    context.nextToken();
                    tableInputBuilder.retention((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("StorageDescriptor", targetDepth)) {
                    context.nextToken();
                    tableInputBuilder.storageDescriptor(StorageDescriptorUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("PartitionKeys", targetDepth)) {
                    context.nextToken();
                    tableInputBuilder.partitionKeys(new ListUnmarshaller((Unmarshaller)ColumnUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("ViewOriginalText", targetDepth)) {
                    context.nextToken();
                    tableInputBuilder.viewOriginalText((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ViewExpandedText", targetDepth)) {
                    context.nextToken();
                    tableInputBuilder.viewExpandedText((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("TableType", targetDepth)) {
                    context.nextToken();
                    tableInputBuilder.tableType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Parameters", targetDepth)) {
                    context.nextToken();
                    tableInputBuilder.parameters(new MapUnmarshaller(context.getUnmarshaller(String.class), context.getUnmarshaller(String.class)).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (TableInput)tableInputBuilder.build();
    }

    public static TableInputUnmarshaller getInstance() {
        return INSTANCE;
    }
}

