/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.glue.model.StorageDescriptor;

@SdkInternalApi
public class StorageDescriptorMarshaller {
    private static final MarshallingInfo<List> COLUMNS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Columns").build();
    private static final MarshallingInfo<String> LOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Location").build();
    private static final MarshallingInfo<String> INPUTFORMAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InputFormat").build();
    private static final MarshallingInfo<String> OUTPUTFORMAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutputFormat").build();
    private static final MarshallingInfo<Boolean> COMPRESSED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Compressed").build();
    private static final MarshallingInfo<Integer> NUMBEROFBUCKETS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NumberOfBuckets").build();
    private static final MarshallingInfo<StructuredPojo> SERDEINFO_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SerdeInfo").build();
    private static final MarshallingInfo<List> BUCKETCOLUMNS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BucketColumns").build();
    private static final MarshallingInfo<List> SORTCOLUMNS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SortColumns").build();
    private static final MarshallingInfo<Map> PARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Parameters").build();
    private static final MarshallingInfo<StructuredPojo> SKEWEDINFO_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SkewedInfo").build();
    private static final MarshallingInfo<Boolean> STOREDASSUBDIRECTORIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StoredAsSubDirectories").build();
    private static final StorageDescriptorMarshaller INSTANCE = new StorageDescriptorMarshaller();

    public static StorageDescriptorMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(StorageDescriptor storageDescriptor, ProtocolMarshaller protocolMarshaller) {
        if (storageDescriptor == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(storageDescriptor.columns(), COLUMNS_BINDING);
            protocolMarshaller.marshall((Object)storageDescriptor.location(), LOCATION_BINDING);
            protocolMarshaller.marshall((Object)storageDescriptor.inputFormat(), INPUTFORMAT_BINDING);
            protocolMarshaller.marshall((Object)storageDescriptor.outputFormat(), OUTPUTFORMAT_BINDING);
            protocolMarshaller.marshall((Object)storageDescriptor.compressed(), COMPRESSED_BINDING);
            protocolMarshaller.marshall((Object)storageDescriptor.numberOfBuckets(), NUMBEROFBUCKETS_BINDING);
            protocolMarshaller.marshall((Object)storageDescriptor.serdeInfo(), SERDEINFO_BINDING);
            protocolMarshaller.marshall(storageDescriptor.bucketColumns(), BUCKETCOLUMNS_BINDING);
            protocolMarshaller.marshall(storageDescriptor.sortColumns(), SORTCOLUMNS_BINDING);
            protocolMarshaller.marshall(storageDescriptor.parameters(), PARAMETERS_BINDING);
            protocolMarshaller.marshall((Object)storageDescriptor.skewedInfo(), SKEWEDINFO_BINDING);
            protocolMarshaller.marshall((Object)storageDescriptor.storedAsSubDirectories(), STOREDASSUBDIRECTORIES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

