/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glue.model.Predicate;

@SdkInternalApi
public class PredicateMarshaller {
    private static final MarshallingInfo<String> LOGICAL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Logical").build();
    private static final MarshallingInfo<List> CONDITIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Conditions").build();
    private static final PredicateMarshaller INSTANCE = new PredicateMarshaller();

    public static PredicateMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Predicate predicate, ProtocolMarshaller protocolMarshaller) {
        if (predicate == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)predicate.logicalString(), LOGICAL_BINDING);
            protocolMarshaller.marshall(predicate.conditions(), CONDITIONS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

