/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.glue.model.PartitionError;

@SdkInternalApi
public class PartitionErrorMarshaller {
    private static final MarshallingInfo<List> PARTITIONVALUES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PartitionValues").build();
    private static final MarshallingInfo<StructuredPojo> ERRORDETAIL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ErrorDetail").build();
    private static final PartitionErrorMarshaller INSTANCE = new PartitionErrorMarshaller();

    public static PartitionErrorMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(PartitionError partitionError, ProtocolMarshaller protocolMarshaller) {
        if (partitionError == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(partitionError.partitionValues(), PARTITIONVALUES_BINDING);
            protocolMarshaller.marshall((Object)partitionError.errorDetail(), ERRORDETAIL_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

