/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glue.model.LastCrawlInfo;

@SdkInternalApi
public class LastCrawlInfoMarshaller {
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final MarshallingInfo<String> ERRORMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ErrorMessage").build();
    private static final MarshallingInfo<String> LOGGROUP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LogGroup").build();
    private static final MarshallingInfo<String> LOGSTREAM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LogStream").build();
    private static final MarshallingInfo<String> MESSAGEPREFIX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MessagePrefix").build();
    private static final MarshallingInfo<Instant> STARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartTime").build();
    private static final LastCrawlInfoMarshaller INSTANCE = new LastCrawlInfoMarshaller();

    public static LastCrawlInfoMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(LastCrawlInfo lastCrawlInfo, ProtocolMarshaller protocolMarshaller) {
        if (lastCrawlInfo == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)lastCrawlInfo.statusString(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)lastCrawlInfo.errorMessage(), ERRORMESSAGE_BINDING);
            protocolMarshaller.marshall((Object)lastCrawlInfo.logGroup(), LOGGROUP_BINDING);
            protocolMarshaller.marshall((Object)lastCrawlInfo.logStream(), LOGSTREAM_BINDING);
            protocolMarshaller.marshall((Object)lastCrawlInfo.messagePrefix(), MESSAGEPREFIX_BINDING);
            protocolMarshaller.marshall((Object)lastCrawlInfo.startTime(), STARTTIME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

