/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import java.time.Instant;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glue.model.JobRun;

@SdkInternalApi
public class JobRunMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").build();
    private static final MarshallingInfo<Integer> ATTEMPT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Attempt").build();
    private static final MarshallingInfo<String> PREVIOUSRUNID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PreviousRunId").build();
    private static final MarshallingInfo<String> TRIGGERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TriggerName").build();
    private static final MarshallingInfo<String> JOBNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobName").build();
    private static final MarshallingInfo<Instant> STARTEDON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartedOn").build();
    private static final MarshallingInfo<Instant> LASTMODIFIEDON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastModifiedOn").build();
    private static final MarshallingInfo<Instant> COMPLETEDON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CompletedOn").build();
    private static final MarshallingInfo<String> JOBRUNSTATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobRunState").build();
    private static final MarshallingInfo<Map> ARGUMENTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Arguments").build();
    private static final MarshallingInfo<String> ERRORMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ErrorMessage").build();
    private static final MarshallingInfo<List> PREDECESSORRUNS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PredecessorRuns").build();
    private static final MarshallingInfo<Integer> ALLOCATEDCAPACITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AllocatedCapacity").build();
    private static final JobRunMarshaller INSTANCE = new JobRunMarshaller();

    public static JobRunMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(JobRun jobRun, ProtocolMarshaller protocolMarshaller) {
        if (jobRun == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)jobRun.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)jobRun.attempt(), ATTEMPT_BINDING);
            protocolMarshaller.marshall((Object)jobRun.previousRunId(), PREVIOUSRUNID_BINDING);
            protocolMarshaller.marshall((Object)jobRun.triggerName(), TRIGGERNAME_BINDING);
            protocolMarshaller.marshall((Object)jobRun.jobName(), JOBNAME_BINDING);
            protocolMarshaller.marshall((Object)jobRun.startedOn(), STARTEDON_BINDING);
            protocolMarshaller.marshall((Object)jobRun.lastModifiedOn(), LASTMODIFIEDON_BINDING);
            protocolMarshaller.marshall((Object)jobRun.completedOn(), COMPLETEDON_BINDING);
            protocolMarshaller.marshall((Object)jobRun.jobRunStateString(), JOBRUNSTATE_BINDING);
            protocolMarshaller.marshall(jobRun.arguments(), ARGUMENTS_BINDING);
            protocolMarshaller.marshall((Object)jobRun.errorMessage(), ERRORMESSAGE_BINDING);
            protocolMarshaller.marshall(jobRun.predecessorRuns(), PREDECESSORRUNS_BINDING);
            protocolMarshaller.marshall((Object)jobRun.allocatedCapacity(), ALLOCATEDCAPACITY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

