/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glue.model.JobBookmarkEntry;

@SdkInternalApi
public class JobBookmarkEntryMarshaller {
    private static final MarshallingInfo<String> JOBNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobName").build();
    private static final MarshallingInfo<Integer> VERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Version").build();
    private static final MarshallingInfo<Integer> RUN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Run").build();
    private static final MarshallingInfo<Integer> ATTEMPT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Attempt").build();
    private static final MarshallingInfo<String> JOBBOOKMARK_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobBookmark").build();
    private static final JobBookmarkEntryMarshaller INSTANCE = new JobBookmarkEntryMarshaller();

    public static JobBookmarkEntryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(JobBookmarkEntry jobBookmarkEntry, ProtocolMarshaller protocolMarshaller) {
        if (jobBookmarkEntry == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)jobBookmarkEntry.jobName(), JOBNAME_BINDING);
            protocolMarshaller.marshall((Object)jobBookmarkEntry.version(), VERSION_BINDING);
            protocolMarshaller.marshall((Object)jobBookmarkEntry.run(), RUN_BINDING);
            protocolMarshaller.marshall((Object)jobBookmarkEntry.attempt(), ATTEMPT_BINDING);
            protocolMarshaller.marshall((Object)jobBookmarkEntry.jobBookmark(), JOBBOOKMARK_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

