/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.glue.model.CreateTriggerRequest;

@SdkInternalApi
public class CreateTriggerRequestModelMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Type").build();
    private static final MarshallingInfo<String> SCHEDULE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Schedule").build();
    private static final MarshallingInfo<StructuredPojo> PREDICATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Predicate").build();
    private static final MarshallingInfo<List> ACTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Actions").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").build();
    private static final CreateTriggerRequestModelMarshaller INSTANCE = new CreateTriggerRequestModelMarshaller();

    public static CreateTriggerRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateTriggerRequest createTriggerRequest, ProtocolMarshaller protocolMarshaller) {
        if (createTriggerRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)createTriggerRequest.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)createTriggerRequest.typeString(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)createTriggerRequest.schedule(), SCHEDULE_BINDING);
            protocolMarshaller.marshall((Object)createTriggerRequest.predicate(), PREDICATE_BINDING);
            protocolMarshaller.marshall(createTriggerRequest.actions(), ACTIONS_BINDING);
            protocolMarshaller.marshall((Object)createTriggerRequest.description(), DESCRIPTION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

