/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.glue.model.CrawlerTargets;
import software.amazon.awssdk.services.glue.transform.JdbcTargetUnmarshaller;
import software.amazon.awssdk.services.glue.transform.S3TargetUnmarshaller;

public class CrawlerTargetsUnmarshaller
implements Unmarshaller<CrawlerTargets, JsonUnmarshallerContext> {
    private static final CrawlerTargetsUnmarshaller INSTANCE = new CrawlerTargetsUnmarshaller();

    public CrawlerTargets unmarshall(JsonUnmarshallerContext context) throws Exception {
        CrawlerTargets.Builder crawlerTargetsBuilder = CrawlerTargets.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("S3Targets", targetDepth)) {
                    context.nextToken();
                    crawlerTargetsBuilder.s3Targets(new ListUnmarshaller((Unmarshaller)S3TargetUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("JdbcTargets", targetDepth)) {
                    context.nextToken();
                    crawlerTargetsBuilder.jdbcTargets(new ListUnmarshaller((Unmarshaller)JdbcTargetUnmarshaller.getInstance()).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (CrawlerTargets)crawlerTargetsBuilder.build();
    }

    public static CrawlerTargetsUnmarshaller getInstance() {
        return INSTANCE;
    }
}

