/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.model.GetJobsRequest;
import software.amazon.awssdk.services.glue.model.GetJobsResponse;

public final class GetJobsPaginator
implements SdkIterable<GetJobsResponse> {
    private final GlueClient client;
    private final GetJobsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public GetJobsPaginator(GlueClient client, GetJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetJobsResponseFetcher();
    }

    public Iterator<GetJobsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class GetJobsResponseFetcher
    implements NextPageFetcher<GetJobsResponse> {
        private GetJobsResponseFetcher() {
        }

        public boolean hasNextPage(GetJobsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public GetJobsResponse nextPage(GetJobsResponse previousPage) {
            if (previousPage == null) {
                return GetJobsPaginator.this.client.getJobs(GetJobsPaginator.this.firstRequest);
            }
            return GetJobsPaginator.this.client.getJobs((GetJobsRequest)((Object)GetJobsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

