/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.model.GetJobRunsRequest;
import software.amazon.awssdk.services.glue.model.GetJobRunsResponse;

public final class GetJobRunsPaginator
implements SdkIterable<GetJobRunsResponse> {
    private final GlueClient client;
    private final GetJobRunsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public GetJobRunsPaginator(GlueClient client, GetJobRunsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetJobRunsResponseFetcher();
    }

    public Iterator<GetJobRunsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class GetJobRunsResponseFetcher
    implements NextPageFetcher<GetJobRunsResponse> {
        private GetJobRunsResponseFetcher() {
        }

        public boolean hasNextPage(GetJobRunsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public GetJobRunsResponse nextPage(GetJobRunsResponse previousPage) {
            if (previousPage == null) {
                return GetJobRunsPaginator.this.client.getJobRuns(GetJobRunsPaginator.this.firstRequest);
            }
            return GetJobRunsPaginator.this.client.getJobRuns((GetJobRunsRequest)((Object)GetJobRunsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

