/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.model.GetDevEndpointsRequest;
import software.amazon.awssdk.services.glue.model.GetDevEndpointsResponse;

public final class GetDevEndpointsPaginator
implements SdkIterable<GetDevEndpointsResponse> {
    private final GlueClient client;
    private final GetDevEndpointsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public GetDevEndpointsPaginator(GlueClient client, GetDevEndpointsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetDevEndpointsResponseFetcher();
    }

    public Iterator<GetDevEndpointsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class GetDevEndpointsResponseFetcher
    implements NextPageFetcher<GetDevEndpointsResponse> {
        private GetDevEndpointsResponseFetcher() {
        }

        public boolean hasNextPage(GetDevEndpointsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public GetDevEndpointsResponse nextPage(GetDevEndpointsResponse previousPage) {
            if (previousPage == null) {
                return GetDevEndpointsPaginator.this.client.getDevEndpoints(GetDevEndpointsPaginator.this.firstRequest);
            }
            return GetDevEndpointsPaginator.this.client.getDevEndpoints((GetDevEndpointsRequest)((Object)GetDevEndpointsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

