/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.model.GetConnectionsRequest;
import software.amazon.awssdk.services.glue.model.GetConnectionsResponse;

public final class GetConnectionsPaginator
implements SdkIterable<GetConnectionsResponse> {
    private final GlueClient client;
    private final GetConnectionsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public GetConnectionsPaginator(GlueClient client, GetConnectionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetConnectionsResponseFetcher();
    }

    public Iterator<GetConnectionsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class GetConnectionsResponseFetcher
    implements NextPageFetcher<GetConnectionsResponse> {
        private GetConnectionsResponseFetcher() {
        }

        public boolean hasNextPage(GetConnectionsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public GetConnectionsResponse nextPage(GetConnectionsResponse previousPage) {
            if (previousPage == null) {
                return GetConnectionsPaginator.this.client.getConnections(GetConnectionsPaginator.this.firstRequest);
            }
            return GetConnectionsPaginator.this.client.getConnections((GetConnectionsRequest)((Object)GetConnectionsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

