/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.glue.model.ScheduleState;
import software.amazon.awssdk.services.glue.transform.ScheduleMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Schedule
implements StructuredPojo,
ToCopyableBuilder<Builder, Schedule> {
    private final String scheduleExpression;
    private final String state;

    private Schedule(BuilderImpl builder) {
        this.scheduleExpression = builder.scheduleExpression;
        this.state = builder.state;
    }

    public String scheduleExpression() {
        return this.scheduleExpression;
    }

    public ScheduleState state() {
        return ScheduleState.fromValue(this.state);
    }

    public String stateString() {
        return this.state;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Schedule)) {
            return false;
        }
        Schedule other = (Schedule)obj;
        return Objects.equals(this.scheduleExpression(), other.scheduleExpression()) && Objects.equals(this.stateString(), other.stateString());
    }

    public String toString() {
        return ToString.builder((String)"Schedule").add("ScheduleExpression", (Object)this.scheduleExpression()).add("State", (Object)this.stateString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ScheduleExpression": {
                return Optional.of(clazz.cast(this.scheduleExpression()));
            }
            case "State": {
                return Optional.of(clazz.cast(this.stateString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ScheduleMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String scheduleExpression;
        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(Schedule model) {
            this.scheduleExpression(model.scheduleExpression);
            this.state(model.state);
        }

        public final String getScheduleExpression() {
            return this.scheduleExpression;
        }

        @Override
        public final Builder scheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
            return this;
        }

        public final void setScheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ScheduleState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public Schedule build() {
            return new Schedule(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Schedule> {
        public Builder scheduleExpression(String var1);

        public Builder state(String var1);

        public Builder state(ScheduleState var1);
    }
}

