/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.glue.model.PathListCopier;
import software.amazon.awssdk.services.glue.transform.S3TargetMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class S3Target
implements StructuredPojo,
ToCopyableBuilder<Builder, S3Target> {
    private final String path;
    private final List<String> exclusions;

    private S3Target(BuilderImpl builder) {
        this.path = builder.path;
        this.exclusions = builder.exclusions;
    }

    public String path() {
        return this.path;
    }

    public List<String> exclusions() {
        return this.exclusions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.path());
        hashCode = 31 * hashCode + Objects.hashCode(this.exclusions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Target)) {
            return false;
        }
        S3Target other = (S3Target)obj;
        return Objects.equals(this.path(), other.path()) && Objects.equals(this.exclusions(), other.exclusions());
    }

    public String toString() {
        return ToString.builder((String)"S3Target").add("Path", (Object)this.path()).add("Exclusions", this.exclusions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Path": {
                return Optional.of(clazz.cast(this.path()));
            }
            case "Exclusions": {
                return Optional.of(clazz.cast(this.exclusions()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3TargetMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String path;
        private List<String> exclusions;

        private BuilderImpl() {
        }

        private BuilderImpl(S3Target model) {
            this.path(model.path);
            this.exclusions(model.exclusions);
        }

        public final String getPath() {
            return this.path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        public final Collection<String> getExclusions() {
            return this.exclusions;
        }

        @Override
        public final Builder exclusions(Collection<String> exclusions) {
            this.exclusions = PathListCopier.copy(exclusions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exclusions(String ... exclusions) {
            this.exclusions(Arrays.asList(exclusions));
            return this;
        }

        public final void setExclusions(Collection<String> exclusions) {
            this.exclusions = PathListCopier.copy(exclusions);
        }

        public S3Target build() {
            return new S3Target(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, S3Target> {
        public Builder path(String var1);

        public Builder exclusions(Collection<String> var1);

        public Builder exclusions(String ... var1);
    }
}

