/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.glue.model.CodeGenEdge;
import software.amazon.awssdk.services.glue.model.CodeGenNode;
import software.amazon.awssdk.services.glue.model.DagEdgesCopier;
import software.amazon.awssdk.services.glue.model.DagNodesCopier;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetDataflowGraphResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, GetDataflowGraphResponse> {
    private final List<CodeGenNode> dagNodes;
    private final List<CodeGenEdge> dagEdges;

    private GetDataflowGraphResponse(BuilderImpl builder) {
        super(builder);
        this.dagNodes = builder.dagNodes;
        this.dagEdges = builder.dagEdges;
    }

    public List<CodeGenNode> dagNodes() {
        return this.dagNodes;
    }

    public List<CodeGenEdge> dagEdges() {
        return this.dagEdges;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dagNodes());
        hashCode = 31 * hashCode + Objects.hashCode(this.dagEdges());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDataflowGraphResponse)) {
            return false;
        }
        GetDataflowGraphResponse other = (GetDataflowGraphResponse)((Object)obj);
        return Objects.equals(this.dagNodes(), other.dagNodes()) && Objects.equals(this.dagEdges(), other.dagEdges());
    }

    public String toString() {
        return ToString.builder((String)"GetDataflowGraphResponse").add("DagNodes", this.dagNodes()).add("DagEdges", this.dagEdges()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DagNodes": {
                return Optional.of(clazz.cast(this.dagNodes()));
            }
            case "DagEdges": {
                return Optional.of(clazz.cast(this.dagEdges()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private List<CodeGenNode> dagNodes;
        private List<CodeGenEdge> dagEdges;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDataflowGraphResponse model) {
            this.dagNodes(model.dagNodes);
            this.dagEdges(model.dagEdges);
        }

        public final Collection<CodeGenNode.Builder> getDagNodes() {
            return this.dagNodes != null ? (Collection)this.dagNodes.stream().map(CodeGenNode::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dagNodes(Collection<CodeGenNode> dagNodes) {
            this.dagNodes = DagNodesCopier.copy(dagNodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dagNodes(CodeGenNode ... dagNodes) {
            this.dagNodes(Arrays.asList(dagNodes));
            return this;
        }

        public final void setDagNodes(Collection<CodeGenNode.BuilderImpl> dagNodes) {
            this.dagNodes = DagNodesCopier.copyFromBuilder(dagNodes);
        }

        public final Collection<CodeGenEdge.Builder> getDagEdges() {
            return this.dagEdges != null ? (Collection)this.dagEdges.stream().map(CodeGenEdge::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dagEdges(Collection<CodeGenEdge> dagEdges) {
            this.dagEdges = DagEdgesCopier.copy(dagEdges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dagEdges(CodeGenEdge ... dagEdges) {
            this.dagEdges(Arrays.asList(dagEdges));
            return this;
        }

        public final void setDagEdges(Collection<CodeGenEdge.BuilderImpl> dagEdges) {
            this.dagEdges = DagEdgesCopier.copyFromBuilder(dagEdges);
        }

        @Override
        public GetDataflowGraphResponse build() {
            return new GetDataflowGraphResponse(this);
        }
    }

    public static interface Builder
    extends GlueResponse.Builder,
    CopyableBuilder<Builder, GetDataflowGraphResponse> {
        public Builder dagNodes(Collection<CodeGenNode> var1);

        public Builder dagNodes(CodeGenNode ... var1);

        public Builder dagEdges(Collection<CodeGenEdge> var1);

        public Builder dagEdges(CodeGenEdge ... var1);
    }
}

