/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.glue.model.CrawlerMetrics;
import software.amazon.awssdk.services.glue.model.CrawlerMetricsListCopier;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetCrawlerMetricsResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, GetCrawlerMetricsResponse> {
    private final List<CrawlerMetrics> crawlerMetricsList;
    private final String nextToken;

    private GetCrawlerMetricsResponse(BuilderImpl builder) {
        super(builder);
        this.crawlerMetricsList = builder.crawlerMetricsList;
        this.nextToken = builder.nextToken;
    }

    public List<CrawlerMetrics> crawlerMetricsList() {
        return this.crawlerMetricsList;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.crawlerMetricsList());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCrawlerMetricsResponse)) {
            return false;
        }
        GetCrawlerMetricsResponse other = (GetCrawlerMetricsResponse)((Object)obj);
        return Objects.equals(this.crawlerMetricsList(), other.crawlerMetricsList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"GetCrawlerMetricsResponse").add("CrawlerMetricsList", this.crawlerMetricsList()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CrawlerMetricsList": {
                return Optional.of(clazz.cast(this.crawlerMetricsList()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private List<CrawlerMetrics> crawlerMetricsList;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCrawlerMetricsResponse model) {
            this.crawlerMetricsList(model.crawlerMetricsList);
            this.nextToken(model.nextToken);
        }

        public final Collection<CrawlerMetrics.Builder> getCrawlerMetricsList() {
            return this.crawlerMetricsList != null ? (Collection)this.crawlerMetricsList.stream().map(CrawlerMetrics::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder crawlerMetricsList(Collection<CrawlerMetrics> crawlerMetricsList) {
            this.crawlerMetricsList = CrawlerMetricsListCopier.copy(crawlerMetricsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder crawlerMetricsList(CrawlerMetrics ... crawlerMetricsList) {
            this.crawlerMetricsList(Arrays.asList(crawlerMetricsList));
            return this;
        }

        public final void setCrawlerMetricsList(Collection<CrawlerMetrics.BuilderImpl> crawlerMetricsList) {
            this.crawlerMetricsList = CrawlerMetricsListCopier.copyFromBuilder(crawlerMetricsList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetCrawlerMetricsResponse build() {
            return new GetCrawlerMetricsResponse(this);
        }
    }

    public static interface Builder
    extends GlueResponse.Builder,
    CopyableBuilder<Builder, GetCrawlerMetricsResponse> {
        public Builder crawlerMetricsList(Collection<CrawlerMetrics> var1);

        public Builder crawlerMetricsList(CrawlerMetrics ... var1);

        public Builder nextToken(String var1);
    }
}

