/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.glue.model.Classifier;
import software.amazon.awssdk.services.glue.model.ClassifierListCopier;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetClassifiersResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, GetClassifiersResponse> {
    private final List<Classifier> classifiers;
    private final String nextToken;

    private GetClassifiersResponse(BuilderImpl builder) {
        super(builder);
        this.classifiers = builder.classifiers;
        this.nextToken = builder.nextToken;
    }

    public List<Classifier> classifiers() {
        return this.classifiers;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.classifiers());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetClassifiersResponse)) {
            return false;
        }
        GetClassifiersResponse other = (GetClassifiersResponse)((Object)obj);
        return Objects.equals(this.classifiers(), other.classifiers()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"GetClassifiersResponse").add("Classifiers", this.classifiers()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Classifiers": {
                return Optional.of(clazz.cast(this.classifiers()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private List<Classifier> classifiers;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetClassifiersResponse model) {
            this.classifiers(model.classifiers);
            this.nextToken(model.nextToken);
        }

        public final Collection<Classifier.Builder> getClassifiers() {
            return this.classifiers != null ? (Collection)this.classifiers.stream().map(Classifier::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder classifiers(Collection<Classifier> classifiers) {
            this.classifiers = ClassifierListCopier.copy(classifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder classifiers(Classifier ... classifiers) {
            this.classifiers(Arrays.asList(classifiers));
            return this;
        }

        public final void setClassifiers(Collection<Classifier.BuilderImpl> classifiers) {
            this.classifiers = ClassifierListCopier.copyFromBuilder(classifiers);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetClassifiersResponse build() {
            return new GetClassifiersResponse(this);
        }
    }

    public static interface Builder
    extends GlueResponse.Builder,
    CopyableBuilder<Builder, GetClassifiersResponse> {
        public Builder classifiers(Collection<Classifier> var1);

        public Builder classifiers(Classifier ... var1);

        public Builder nextToken(String var1);
    }
}

