/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.services.glue.model.PartitionInput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreatePartitionRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, CreatePartitionRequest> {
    private final String catalogId;
    private final String databaseName;
    private final String tableName;
    private final PartitionInput partitionInput;

    private CreatePartitionRequest(BuilderImpl builder) {
        super(builder);
        this.catalogId = builder.catalogId;
        this.databaseName = builder.databaseName;
        this.tableName = builder.tableName;
        this.partitionInput = builder.partitionInput;
    }

    public String catalogId() {
        return this.catalogId;
    }

    public String databaseName() {
        return this.databaseName;
    }

    public String tableName() {
        return this.tableName;
    }

    public PartitionInput partitionInput() {
        return this.partitionInput;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.partitionInput());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePartitionRequest)) {
            return false;
        }
        CreatePartitionRequest other = (CreatePartitionRequest)((Object)obj);
        return Objects.equals(this.catalogId(), other.catalogId()) && Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.tableName(), other.tableName()) && Objects.equals(this.partitionInput(), other.partitionInput());
    }

    public String toString() {
        return ToString.builder((String)"CreatePartitionRequest").add("CatalogId", (Object)this.catalogId()).add("DatabaseName", (Object)this.databaseName()).add("TableName", (Object)this.tableName()).add("PartitionInput", (Object)this.partitionInput()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CatalogId": {
                return Optional.of(clazz.cast(this.catalogId()));
            }
            case "DatabaseName": {
                return Optional.of(clazz.cast(this.databaseName()));
            }
            case "TableName": {
                return Optional.of(clazz.cast(this.tableName()));
            }
            case "PartitionInput": {
                return Optional.of(clazz.cast(this.partitionInput()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private String catalogId;
        private String databaseName;
        private String tableName;
        private PartitionInput partitionInput;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePartitionRequest model) {
            this.catalogId(model.catalogId);
            this.databaseName(model.databaseName);
            this.tableName(model.tableName);
            this.partitionInput(model.partitionInput);
        }

        public final String getCatalogId() {
            return this.catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        public final String getTableName() {
            return this.tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final PartitionInput.Builder getPartitionInput() {
            return this.partitionInput != null ? this.partitionInput.toBuilder() : null;
        }

        @Override
        public final Builder partitionInput(PartitionInput partitionInput) {
            this.partitionInput = partitionInput;
            return this;
        }

        public final void setPartitionInput(PartitionInput.BuilderImpl partitionInput) {
            this.partitionInput = partitionInput != null ? partitionInput.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreatePartitionRequest build() {
            return new CreatePartitionRequest(this);
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    CopyableBuilder<Builder, CreatePartitionRequest> {
        public Builder catalogId(String var1);

        public Builder databaseName(String var1);

        public Builder tableName(String var1);

        public Builder partitionInput(PartitionInput var1);

        default public Builder partitionInput(Consumer<PartitionInput.Builder> partitionInput) {
            return this.partitionInput((PartitionInput)((PartitionInput.Builder)PartitionInput.builder().apply(partitionInput)).build());
        }

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

