/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.glue.model.DatabaseInput;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateDatabaseRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, CreateDatabaseRequest> {
    private final String catalogId;
    private final DatabaseInput databaseInput;

    private CreateDatabaseRequest(BuilderImpl builder) {
        super(builder);
        this.catalogId = builder.catalogId;
        this.databaseInput = builder.databaseInput;
    }

    public String catalogId() {
        return this.catalogId;
    }

    public DatabaseInput databaseInput() {
        return this.databaseInput;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseInput());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDatabaseRequest)) {
            return false;
        }
        CreateDatabaseRequest other = (CreateDatabaseRequest)((Object)obj);
        return Objects.equals(this.catalogId(), other.catalogId()) && Objects.equals(this.databaseInput(), other.databaseInput());
    }

    public String toString() {
        return ToString.builder((String)"CreateDatabaseRequest").add("CatalogId", (Object)this.catalogId()).add("DatabaseInput", (Object)this.databaseInput()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CatalogId": {
                return Optional.of(clazz.cast(this.catalogId()));
            }
            case "DatabaseInput": {
                return Optional.of(clazz.cast(this.databaseInput()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private String catalogId;
        private DatabaseInput databaseInput;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDatabaseRequest model) {
            this.catalogId(model.catalogId);
            this.databaseInput(model.databaseInput);
        }

        public final String getCatalogId() {
            return this.catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        public final DatabaseInput.Builder getDatabaseInput() {
            return this.databaseInput != null ? this.databaseInput.toBuilder() : null;
        }

        @Override
        public final Builder databaseInput(DatabaseInput databaseInput) {
            this.databaseInput = databaseInput;
            return this;
        }

        public final void setDatabaseInput(DatabaseInput.BuilderImpl databaseInput) {
            this.databaseInput = databaseInput != null ? databaseInput.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateDatabaseRequest build() {
            return new CreateDatabaseRequest(this);
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    CopyableBuilder<Builder, CreateDatabaseRequest> {
        public Builder catalogId(String var1);

        public Builder databaseInput(DatabaseInput var1);

        default public Builder databaseInput(Consumer<DatabaseInput.Builder> databaseInput) {
            return this.databaseInput((DatabaseInput)((DatabaseInput.Builder)DatabaseInput.builder().apply(databaseInput)).build());
        }

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

