/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.glue.transform.BatchStopJobRunSuccessfulSubmissionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BatchStopJobRunSuccessfulSubmission
implements StructuredPojo,
ToCopyableBuilder<Builder, BatchStopJobRunSuccessfulSubmission> {
    private final String jobName;
    private final String jobRunId;

    private BatchStopJobRunSuccessfulSubmission(BuilderImpl builder) {
        this.jobName = builder.jobName;
        this.jobRunId = builder.jobRunId;
    }

    public String jobName() {
        return this.jobName;
    }

    public String jobRunId() {
        return this.jobRunId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobRunId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchStopJobRunSuccessfulSubmission)) {
            return false;
        }
        BatchStopJobRunSuccessfulSubmission other = (BatchStopJobRunSuccessfulSubmission)obj;
        return Objects.equals(this.jobName(), other.jobName()) && Objects.equals(this.jobRunId(), other.jobRunId());
    }

    public String toString() {
        return ToString.builder((String)"BatchStopJobRunSuccessfulSubmission").add("JobName", (Object)this.jobName()).add("JobRunId", (Object)this.jobRunId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobName": {
                return Optional.of(clazz.cast(this.jobName()));
            }
            case "JobRunId": {
                return Optional.of(clazz.cast(this.jobRunId()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BatchStopJobRunSuccessfulSubmissionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String jobName;
        private String jobRunId;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchStopJobRunSuccessfulSubmission model) {
            this.jobName(model.jobName);
            this.jobRunId(model.jobRunId);
        }

        public final String getJobName() {
            return this.jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        public final String getJobRunId() {
            return this.jobRunId;
        }

        @Override
        public final Builder jobRunId(String jobRunId) {
            this.jobRunId = jobRunId;
            return this;
        }

        public final void setJobRunId(String jobRunId) {
            this.jobRunId = jobRunId;
        }

        public BatchStopJobRunSuccessfulSubmission build() {
            return new BatchStopJobRunSuccessfulSubmission(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BatchStopJobRunSuccessfulSubmission> {
        public Builder jobName(String var1);

        public Builder jobRunId(String var1);
    }
}

