/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.glue.model.BatchStopJobRunJobRunIdListCopier;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BatchStopJobRunRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, BatchStopJobRunRequest> {
    private final String jobName;
    private final List<String> jobRunIds;

    private BatchStopJobRunRequest(BuilderImpl builder) {
        super(builder);
        this.jobName = builder.jobName;
        this.jobRunIds = builder.jobRunIds;
    }

    public String jobName() {
        return this.jobName;
    }

    public List<String> jobRunIds() {
        return this.jobRunIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobRunIds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchStopJobRunRequest)) {
            return false;
        }
        BatchStopJobRunRequest other = (BatchStopJobRunRequest)((Object)obj);
        return Objects.equals(this.jobName(), other.jobName()) && Objects.equals(this.jobRunIds(), other.jobRunIds());
    }

    public String toString() {
        return ToString.builder((String)"BatchStopJobRunRequest").add("JobName", (Object)this.jobName()).add("JobRunIds", this.jobRunIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobName": {
                return Optional.of(clazz.cast(this.jobName()));
            }
            case "JobRunIds": {
                return Optional.of(clazz.cast(this.jobRunIds()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private String jobName;
        private List<String> jobRunIds;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchStopJobRunRequest model) {
            this.jobName(model.jobName);
            this.jobRunIds(model.jobRunIds);
        }

        public final String getJobName() {
            return this.jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        public final Collection<String> getJobRunIds() {
            return this.jobRunIds;
        }

        @Override
        public final Builder jobRunIds(Collection<String> jobRunIds) {
            this.jobRunIds = BatchStopJobRunJobRunIdListCopier.copy(jobRunIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobRunIds(String ... jobRunIds) {
            this.jobRunIds(Arrays.asList(jobRunIds));
            return this;
        }

        public final void setJobRunIds(Collection<String> jobRunIds) {
            this.jobRunIds = BatchStopJobRunJobRunIdListCopier.copy(jobRunIds);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public BatchStopJobRunRequest build() {
            return new BatchStopJobRunRequest(this);
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    CopyableBuilder<Builder, BatchStopJobRunRequest> {
        public Builder jobName(String var1);

        public Builder jobRunIds(Collection<String> var1);

        public Builder jobRunIds(String ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

