/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.glue.model.BatchGetPartitionValueListCopier;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.services.glue.model.Partition;
import software.amazon.awssdk.services.glue.model.PartitionListCopier;
import software.amazon.awssdk.services.glue.model.PartitionValueList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BatchGetPartitionResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, BatchGetPartitionResponse> {
    private final List<Partition> partitions;
    private final List<PartitionValueList> unprocessedKeys;

    private BatchGetPartitionResponse(BuilderImpl builder) {
        super(builder);
        this.partitions = builder.partitions;
        this.unprocessedKeys = builder.unprocessedKeys;
    }

    public List<Partition> partitions() {
        return this.partitions;
    }

    public List<PartitionValueList> unprocessedKeys() {
        return this.unprocessedKeys;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.partitions());
        hashCode = 31 * hashCode + Objects.hashCode(this.unprocessedKeys());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetPartitionResponse)) {
            return false;
        }
        BatchGetPartitionResponse other = (BatchGetPartitionResponse)((Object)obj);
        return Objects.equals(this.partitions(), other.partitions()) && Objects.equals(this.unprocessedKeys(), other.unprocessedKeys());
    }

    public String toString() {
        return ToString.builder((String)"BatchGetPartitionResponse").add("Partitions", this.partitions()).add("UnprocessedKeys", this.unprocessedKeys()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Partitions": {
                return Optional.of(clazz.cast(this.partitions()));
            }
            case "UnprocessedKeys": {
                return Optional.of(clazz.cast(this.unprocessedKeys()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private List<Partition> partitions;
        private List<PartitionValueList> unprocessedKeys;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetPartitionResponse model) {
            this.partitions(model.partitions);
            this.unprocessedKeys(model.unprocessedKeys);
        }

        public final Collection<Partition.Builder> getPartitions() {
            return this.partitions != null ? (Collection)this.partitions.stream().map(Partition::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder partitions(Collection<Partition> partitions) {
            this.partitions = PartitionListCopier.copy(partitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partitions(Partition ... partitions) {
            this.partitions(Arrays.asList(partitions));
            return this;
        }

        public final void setPartitions(Collection<Partition.BuilderImpl> partitions) {
            this.partitions = PartitionListCopier.copyFromBuilder(partitions);
        }

        public final Collection<PartitionValueList.Builder> getUnprocessedKeys() {
            return this.unprocessedKeys != null ? (Collection)this.unprocessedKeys.stream().map(PartitionValueList::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder unprocessedKeys(Collection<PartitionValueList> unprocessedKeys) {
            this.unprocessedKeys = BatchGetPartitionValueListCopier.copy(unprocessedKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedKeys(PartitionValueList ... unprocessedKeys) {
            this.unprocessedKeys(Arrays.asList(unprocessedKeys));
            return this;
        }

        public final void setUnprocessedKeys(Collection<PartitionValueList.BuilderImpl> unprocessedKeys) {
            this.unprocessedKeys = BatchGetPartitionValueListCopier.copyFromBuilder(unprocessedKeys);
        }

        @Override
        public BatchGetPartitionResponse build() {
            return new BatchGetPartitionResponse(this);
        }
    }

    public static interface Builder
    extends GlueResponse.Builder,
    CopyableBuilder<Builder, BatchGetPartitionResponse> {
        public Builder partitions(Collection<Partition> var1);

        public Builder partitions(Partition ... var1);

        public Builder unprocessedKeys(Collection<PartitionValueList> var1);

        public Builder unprocessedKeys(PartitionValueList ... var1);
    }
}

