/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.services.glue.model.PartitionInput;
import software.amazon.awssdk.services.glue.model.PartitionInputListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BatchCreatePartitionRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, BatchCreatePartitionRequest> {
    private final String catalogId;
    private final String databaseName;
    private final String tableName;
    private final List<PartitionInput> partitionInputList;

    private BatchCreatePartitionRequest(BuilderImpl builder) {
        super(builder);
        this.catalogId = builder.catalogId;
        this.databaseName = builder.databaseName;
        this.tableName = builder.tableName;
        this.partitionInputList = builder.partitionInputList;
    }

    public String catalogId() {
        return this.catalogId;
    }

    public String databaseName() {
        return this.databaseName;
    }

    public String tableName() {
        return this.tableName;
    }

    public List<PartitionInput> partitionInputList() {
        return this.partitionInputList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.partitionInputList());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchCreatePartitionRequest)) {
            return false;
        }
        BatchCreatePartitionRequest other = (BatchCreatePartitionRequest)((Object)obj);
        return Objects.equals(this.catalogId(), other.catalogId()) && Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.tableName(), other.tableName()) && Objects.equals(this.partitionInputList(), other.partitionInputList());
    }

    public String toString() {
        return ToString.builder((String)"BatchCreatePartitionRequest").add("CatalogId", (Object)this.catalogId()).add("DatabaseName", (Object)this.databaseName()).add("TableName", (Object)this.tableName()).add("PartitionInputList", this.partitionInputList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CatalogId": {
                return Optional.of(clazz.cast(this.catalogId()));
            }
            case "DatabaseName": {
                return Optional.of(clazz.cast(this.databaseName()));
            }
            case "TableName": {
                return Optional.of(clazz.cast(this.tableName()));
            }
            case "PartitionInputList": {
                return Optional.of(clazz.cast(this.partitionInputList()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private String catalogId;
        private String databaseName;
        private String tableName;
        private List<PartitionInput> partitionInputList;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchCreatePartitionRequest model) {
            this.catalogId(model.catalogId);
            this.databaseName(model.databaseName);
            this.tableName(model.tableName);
            this.partitionInputList(model.partitionInputList);
        }

        public final String getCatalogId() {
            return this.catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        public final String getTableName() {
            return this.tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final Collection<PartitionInput.Builder> getPartitionInputList() {
            return this.partitionInputList != null ? (Collection)this.partitionInputList.stream().map(PartitionInput::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder partitionInputList(Collection<PartitionInput> partitionInputList) {
            this.partitionInputList = PartitionInputListCopier.copy(partitionInputList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partitionInputList(PartitionInput ... partitionInputList) {
            this.partitionInputList(Arrays.asList(partitionInputList));
            return this;
        }

        public final void setPartitionInputList(Collection<PartitionInput.BuilderImpl> partitionInputList) {
            this.partitionInputList = PartitionInputListCopier.copyFromBuilder(partitionInputList);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public BatchCreatePartitionRequest build() {
            return new BatchCreatePartitionRequest(this);
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    CopyableBuilder<Builder, BatchCreatePartitionRequest> {
        public Builder catalogId(String var1);

        public Builder databaseName(String var1);

        public Builder tableName(String var1);

        public Builder partitionInputList(Collection<PartitionInput> var1);

        public Builder partitionInputList(PartitionInput ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

