/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.glue.model.GenericMapCopier;
import software.amazon.awssdk.services.glue.transform.ActionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Action
implements StructuredPojo,
ToCopyableBuilder<Builder, Action> {
    private final String jobName;
    private final Map<String, String> arguments;

    private Action(BuilderImpl builder) {
        this.jobName = builder.jobName;
        this.arguments = builder.arguments;
    }

    public String jobName() {
        return this.jobName;
    }

    public Map<String, String> arguments() {
        return this.arguments;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.arguments());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Action)) {
            return false;
        }
        Action other = (Action)obj;
        return Objects.equals(this.jobName(), other.jobName()) && Objects.equals(this.arguments(), other.arguments());
    }

    public String toString() {
        return ToString.builder((String)"Action").add("JobName", (Object)this.jobName()).add("Arguments", this.arguments()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobName": {
                return Optional.of(clazz.cast(this.jobName()));
            }
            case "Arguments": {
                return Optional.of(clazz.cast(this.arguments()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ActionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String jobName;
        private Map<String, String> arguments;

        private BuilderImpl() {
        }

        private BuilderImpl(Action model) {
            this.jobName(model.jobName);
            this.arguments(model.arguments);
        }

        public final String getJobName() {
            return this.jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        public final Map<String, String> getArguments() {
            return this.arguments;
        }

        @Override
        public final Builder arguments(Map<String, String> arguments) {
            this.arguments = GenericMapCopier.copy(arguments);
            return this;
        }

        public final void setArguments(Map<String, String> arguments) {
            this.arguments = GenericMapCopier.copy(arguments);
        }

        public Action build() {
            return new Action(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Action> {
        public Builder jobName(String var1);

        public Builder arguments(Map<String, String> var1);
    }
}

