/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glue.model.UserDefinedFunctionInput;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class UserDefinedFunctionInputMarshaller {
    private static final MarshallingInfo<String> FUNCTIONNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FunctionName").isBinary(false).build();
    private static final MarshallingInfo<String> CLASSNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClassName").isBinary(false).build();
    private static final MarshallingInfo<String> OWNERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OwnerName").isBinary(false).build();
    private static final MarshallingInfo<String> OWNERTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OwnerType").isBinary(false).build();
    private static final MarshallingInfo<List> RESOURCEURIS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceUris").isBinary(false).build();
    private static final UserDefinedFunctionInputMarshaller INSTANCE = new UserDefinedFunctionInputMarshaller();

    private UserDefinedFunctionInputMarshaller() {
    }

    public static UserDefinedFunctionInputMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(UserDefinedFunctionInput userDefinedFunctionInput, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)userDefinedFunctionInput, (String)"userDefinedFunctionInput");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)userDefinedFunctionInput.functionName(), FUNCTIONNAME_BINDING);
            protocolMarshaller.marshall((Object)userDefinedFunctionInput.className(), CLASSNAME_BINDING);
            protocolMarshaller.marshall((Object)userDefinedFunctionInput.ownerName(), OWNERNAME_BINDING);
            protocolMarshaller.marshall((Object)userDefinedFunctionInput.ownerTypeAsString(), OWNERTYPE_BINDING);
            protocolMarshaller.marshall(userDefinedFunctionInput.resourceUris(), RESOURCEURIS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

