/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.glue.model.UpdateConnectionRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class UpdateConnectionRequestModelMarshaller {
    private static final MarshallingInfo<String> CATALOGID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CatalogId").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> CONNECTIONINPUT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConnectionInput").isBinary(false).build();
    private static final UpdateConnectionRequestModelMarshaller INSTANCE = new UpdateConnectionRequestModelMarshaller();

    private UpdateConnectionRequestModelMarshaller() {
    }

    public static UpdateConnectionRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(UpdateConnectionRequest updateConnectionRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)updateConnectionRequest), (String)"updateConnectionRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)updateConnectionRequest.catalogId(), CATALOGID_BINDING);
            protocolMarshaller.marshall((Object)updateConnectionRequest.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)updateConnectionRequest.connectionInput(), CONNECTIONINPUT_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

