/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.glue.model.TableError;
import software.amazon.awssdk.services.glue.transform.ErrorDetailUnmarshaller;

public class TableErrorUnmarshaller
implements Unmarshaller<TableError, JsonUnmarshallerContext> {
    private static final TableErrorUnmarshaller INSTANCE = new TableErrorUnmarshaller();

    public TableError unmarshall(JsonUnmarshallerContext context) throws Exception {
        TableError.Builder tableErrorBuilder = TableError.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("TableName", targetDepth)) {
                    context.nextToken();
                    tableErrorBuilder.tableName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ErrorDetail", targetDepth)) {
                    context.nextToken();
                    tableErrorBuilder.errorDetail(ErrorDetailUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (TableError)tableErrorBuilder.build();
    }

    public static TableErrorUnmarshaller getInstance() {
        return INSTANCE;
    }
}

