/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.MapUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.glue.model.StorageDescriptor;
import software.amazon.awssdk.services.glue.transform.ColumnUnmarshaller;
import software.amazon.awssdk.services.glue.transform.OrderUnmarshaller;
import software.amazon.awssdk.services.glue.transform.SerDeInfoUnmarshaller;
import software.amazon.awssdk.services.glue.transform.SkewedInfoUnmarshaller;

public class StorageDescriptorUnmarshaller
implements Unmarshaller<StorageDescriptor, JsonUnmarshallerContext> {
    private static final StorageDescriptorUnmarshaller INSTANCE = new StorageDescriptorUnmarshaller();

    public StorageDescriptor unmarshall(JsonUnmarshallerContext context) throws Exception {
        StorageDescriptor.Builder storageDescriptorBuilder = StorageDescriptor.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Columns", targetDepth)) {
                    context.nextToken();
                    storageDescriptorBuilder.columns(new ListUnmarshaller((Unmarshaller)ColumnUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("Location", targetDepth)) {
                    context.nextToken();
                    storageDescriptorBuilder.location((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("InputFormat", targetDepth)) {
                    context.nextToken();
                    storageDescriptorBuilder.inputFormat((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("OutputFormat", targetDepth)) {
                    context.nextToken();
                    storageDescriptorBuilder.outputFormat((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Compressed", targetDepth)) {
                    context.nextToken();
                    storageDescriptorBuilder.compressed((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("NumberOfBuckets", targetDepth)) {
                    context.nextToken();
                    storageDescriptorBuilder.numberOfBuckets((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("SerdeInfo", targetDepth)) {
                    context.nextToken();
                    storageDescriptorBuilder.serdeInfo(SerDeInfoUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("BucketColumns", targetDepth)) {
                    context.nextToken();
                    storageDescriptorBuilder.bucketColumns(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("SortColumns", targetDepth)) {
                    context.nextToken();
                    storageDescriptorBuilder.sortColumns(new ListUnmarshaller((Unmarshaller)OrderUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("Parameters", targetDepth)) {
                    context.nextToken();
                    storageDescriptorBuilder.parameters(new MapUnmarshaller(context.getUnmarshaller(String.class), context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("SkewedInfo", targetDepth)) {
                    context.nextToken();
                    storageDescriptorBuilder.skewedInfo(SkewedInfoUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("StoredAsSubDirectories", targetDepth)) {
                    context.nextToken();
                    storageDescriptorBuilder.storedAsSubDirectories((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (StorageDescriptor)storageDescriptorBuilder.build();
    }

    public static StorageDescriptorUnmarshaller getInstance() {
        return INSTANCE;
    }
}

