/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.glue.model.StorageDescriptor;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class StorageDescriptorMarshaller {
    private static final MarshallingInfo<List> COLUMNS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Columns").isBinary(false).build();
    private static final MarshallingInfo<String> LOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Location").isBinary(false).build();
    private static final MarshallingInfo<String> INPUTFORMAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InputFormat").isBinary(false).build();
    private static final MarshallingInfo<String> OUTPUTFORMAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutputFormat").isBinary(false).build();
    private static final MarshallingInfo<Boolean> COMPRESSED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Compressed").isBinary(false).build();
    private static final MarshallingInfo<Integer> NUMBEROFBUCKETS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NumberOfBuckets").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> SERDEINFO_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SerdeInfo").isBinary(false).build();
    private static final MarshallingInfo<List> BUCKETCOLUMNS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BucketColumns").isBinary(false).build();
    private static final MarshallingInfo<List> SORTCOLUMNS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SortColumns").isBinary(false).build();
    private static final MarshallingInfo<Map> PARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Parameters").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> SKEWEDINFO_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SkewedInfo").isBinary(false).build();
    private static final MarshallingInfo<Boolean> STOREDASSUBDIRECTORIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StoredAsSubDirectories").isBinary(false).build();
    private static final StorageDescriptorMarshaller INSTANCE = new StorageDescriptorMarshaller();

    private StorageDescriptorMarshaller() {
    }

    public static StorageDescriptorMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(StorageDescriptor storageDescriptor, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)storageDescriptor, (String)"storageDescriptor");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(storageDescriptor.columns(), COLUMNS_BINDING);
            protocolMarshaller.marshall((Object)storageDescriptor.location(), LOCATION_BINDING);
            protocolMarshaller.marshall((Object)storageDescriptor.inputFormat(), INPUTFORMAT_BINDING);
            protocolMarshaller.marshall((Object)storageDescriptor.outputFormat(), OUTPUTFORMAT_BINDING);
            protocolMarshaller.marshall((Object)storageDescriptor.compressed(), COMPRESSED_BINDING);
            protocolMarshaller.marshall((Object)storageDescriptor.numberOfBuckets(), NUMBEROFBUCKETS_BINDING);
            protocolMarshaller.marshall((Object)storageDescriptor.serdeInfo(), SERDEINFO_BINDING);
            protocolMarshaller.marshall(storageDescriptor.bucketColumns(), BUCKETCOLUMNS_BINDING);
            protocolMarshaller.marshall(storageDescriptor.sortColumns(), SORTCOLUMNS_BINDING);
            protocolMarshaller.marshall(storageDescriptor.parameters(), PARAMETERS_BINDING);
            protocolMarshaller.marshall((Object)storageDescriptor.skewedInfo(), SKEWEDINFO_BINDING);
            protocolMarshaller.marshall((Object)storageDescriptor.storedAsSubDirectories(), STOREDASSUBDIRECTORIES_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

