/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.glue.model.S3Target;

public class S3TargetUnmarshaller
implements Unmarshaller<S3Target, JsonUnmarshallerContext> {
    private static final S3TargetUnmarshaller INSTANCE = new S3TargetUnmarshaller();

    public S3Target unmarshall(JsonUnmarshallerContext context) throws Exception {
        S3Target.Builder s3TargetBuilder = S3Target.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Path", targetDepth)) {
                    context.nextToken();
                    s3TargetBuilder.path((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Exclusions", targetDepth)) {
                    context.nextToken();
                    s3TargetBuilder.exclusions(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (S3Target)s3TargetBuilder.build();
    }

    public static S3TargetUnmarshaller getInstance() {
        return INSTANCE;
    }
}

