/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.glue.model.JsonClassifier;

public class JsonClassifierUnmarshaller
implements Unmarshaller<JsonClassifier, JsonUnmarshallerContext> {
    private static final JsonClassifierUnmarshaller INSTANCE = new JsonClassifierUnmarshaller();

    public JsonClassifier unmarshall(JsonUnmarshallerContext context) throws Exception {
        JsonClassifier.Builder jsonClassifierBuilder = JsonClassifier.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    jsonClassifierBuilder.name((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("CreationTime", targetDepth)) {
                    context.nextToken();
                    jsonClassifierBuilder.creationTime((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("LastUpdated", targetDepth)) {
                    context.nextToken();
                    jsonClassifierBuilder.lastUpdated((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("Version", targetDepth)) {
                    context.nextToken();
                    jsonClassifierBuilder.version((Long)context.getUnmarshaller(Long.class).unmarshall((Object)context));
                }
                if (context.testExpression("JsonPath", targetDepth)) {
                    context.nextToken();
                    jsonClassifierBuilder.jsonPath((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (JsonClassifier)jsonClassifierBuilder.build();
    }

    public static JsonClassifierUnmarshaller getInstance() {
        return INSTANCE;
    }
}

