/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import java.time.Instant;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.glue.model.JobRun;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class JobRunMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").isBinary(false).build();
    private static final MarshallingInfo<Integer> ATTEMPT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Attempt").isBinary(false).build();
    private static final MarshallingInfo<String> PREVIOUSRUNID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PreviousRunId").isBinary(false).build();
    private static final MarshallingInfo<String> TRIGGERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TriggerName").isBinary(false).build();
    private static final MarshallingInfo<String> JOBNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobName").isBinary(false).build();
    private static final MarshallingInfo<Instant> STARTEDON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartedOn").isBinary(false).build();
    private static final MarshallingInfo<Instant> LASTMODIFIEDON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastModifiedOn").isBinary(false).build();
    private static final MarshallingInfo<Instant> COMPLETEDON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CompletedOn").isBinary(false).build();
    private static final MarshallingInfo<String> JOBRUNSTATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobRunState").isBinary(false).build();
    private static final MarshallingInfo<Map> ARGUMENTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Arguments").isBinary(false).build();
    private static final MarshallingInfo<String> ERRORMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ErrorMessage").isBinary(false).build();
    private static final MarshallingInfo<List> PREDECESSORRUNS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PredecessorRuns").isBinary(false).build();
    private static final MarshallingInfo<Integer> ALLOCATEDCAPACITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AllocatedCapacity").isBinary(false).build();
    private static final MarshallingInfo<Integer> EXECUTIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExecutionTime").isBinary(false).build();
    private static final MarshallingInfo<Integer> TIMEOUT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Timeout").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> NOTIFICATIONPROPERTY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NotificationProperty").isBinary(false).build();
    private static final MarshallingInfo<String> SECURITYCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SecurityConfiguration").isBinary(false).build();
    private static final MarshallingInfo<String> LOGGROUPNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LogGroupName").isBinary(false).build();
    private static final JobRunMarshaller INSTANCE = new JobRunMarshaller();

    private JobRunMarshaller() {
    }

    public static JobRunMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(JobRun jobRun, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)jobRun, (String)"jobRun");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)jobRun.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)jobRun.attempt(), ATTEMPT_BINDING);
            protocolMarshaller.marshall((Object)jobRun.previousRunId(), PREVIOUSRUNID_BINDING);
            protocolMarshaller.marshall((Object)jobRun.triggerName(), TRIGGERNAME_BINDING);
            protocolMarshaller.marshall((Object)jobRun.jobName(), JOBNAME_BINDING);
            protocolMarshaller.marshall((Object)jobRun.startedOn(), STARTEDON_BINDING);
            protocolMarshaller.marshall((Object)jobRun.lastModifiedOn(), LASTMODIFIEDON_BINDING);
            protocolMarshaller.marshall((Object)jobRun.completedOn(), COMPLETEDON_BINDING);
            protocolMarshaller.marshall((Object)jobRun.jobRunStateAsString(), JOBRUNSTATE_BINDING);
            protocolMarshaller.marshall(jobRun.arguments(), ARGUMENTS_BINDING);
            protocolMarshaller.marshall((Object)jobRun.errorMessage(), ERRORMESSAGE_BINDING);
            protocolMarshaller.marshall(jobRun.predecessorRuns(), PREDECESSORRUNS_BINDING);
            protocolMarshaller.marshall((Object)jobRun.allocatedCapacity(), ALLOCATEDCAPACITY_BINDING);
            protocolMarshaller.marshall((Object)jobRun.executionTime(), EXECUTIONTIME_BINDING);
            protocolMarshaller.marshall((Object)jobRun.timeout(), TIMEOUT_BINDING);
            protocolMarshaller.marshall((Object)jobRun.notificationProperty(), NOTIFICATIONPROPERTY_BINDING);
            protocolMarshaller.marshall((Object)jobRun.securityConfiguration(), SECURITYCONFIGURATION_BINDING);
            protocolMarshaller.marshall((Object)jobRun.logGroupName(), LOGGROUPNAME_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

