/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.glue.model.EncryptionConfiguration;
import software.amazon.awssdk.services.glue.transform.CloudWatchEncryptionUnmarshaller;
import software.amazon.awssdk.services.glue.transform.JobBookmarksEncryptionUnmarshaller;
import software.amazon.awssdk.services.glue.transform.S3EncryptionUnmarshaller;

public class EncryptionConfigurationUnmarshaller
implements Unmarshaller<EncryptionConfiguration, JsonUnmarshallerContext> {
    private static final EncryptionConfigurationUnmarshaller INSTANCE = new EncryptionConfigurationUnmarshaller();

    public EncryptionConfiguration unmarshall(JsonUnmarshallerContext context) throws Exception {
        EncryptionConfiguration.Builder encryptionConfigurationBuilder = EncryptionConfiguration.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("S3Encryption", targetDepth)) {
                    context.nextToken();
                    encryptionConfigurationBuilder.s3Encryption(new ListUnmarshaller((Unmarshaller)S3EncryptionUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("CloudWatchEncryption", targetDepth)) {
                    context.nextToken();
                    encryptionConfigurationBuilder.cloudWatchEncryption(CloudWatchEncryptionUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("JobBookmarksEncryption", targetDepth)) {
                    context.nextToken();
                    encryptionConfigurationBuilder.jobBookmarksEncryption(JobBookmarksEncryptionUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (EncryptionConfiguration)encryptionConfigurationBuilder.build();
    }

    public static EncryptionConfigurationUnmarshaller getInstance() {
        return INSTANCE;
    }
}

