/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.glue.model.EncryptionConfiguration;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class EncryptionConfigurationMarshaller {
    private static final MarshallingInfo<List> S3ENCRYPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3Encryption").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> CLOUDWATCHENCRYPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CloudWatchEncryption").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> JOBBOOKMARKSENCRYPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobBookmarksEncryption").isBinary(false).build();
    private static final EncryptionConfigurationMarshaller INSTANCE = new EncryptionConfigurationMarshaller();

    private EncryptionConfigurationMarshaller() {
    }

    public static EncryptionConfigurationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(EncryptionConfiguration encryptionConfiguration, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)encryptionConfiguration, (String)"encryptionConfiguration");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(encryptionConfiguration.s3Encryption(), S3ENCRYPTION_BINDING);
            protocolMarshaller.marshall((Object)encryptionConfiguration.cloudWatchEncryption(), CLOUDWATCHENCRYPTION_BINDING);
            protocolMarshaller.marshall((Object)encryptionConfiguration.jobBookmarksEncryption(), JOBBOOKMARKSENCRYPTION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

