/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glue.model.DynamoDBTarget;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DynamoDBTargetMarshaller {
    private static final MarshallingInfo<String> PATH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Path").isBinary(false).build();
    private static final DynamoDBTargetMarshaller INSTANCE = new DynamoDBTargetMarshaller();

    private DynamoDBTargetMarshaller() {
    }

    public static DynamoDBTargetMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DynamoDBTarget dynamoDBTarget, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)dynamoDBTarget, (String)"dynamoDBTarget");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)dynamoDBTarget.path(), PATH_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

