/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glue.model.CreateScriptRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateScriptRequestModelMarshaller {
    private static final MarshallingInfo<List> DAGNODES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DagNodes").isBinary(false).build();
    private static final MarshallingInfo<List> DAGEDGES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DagEdges").isBinary(false).build();
    private static final MarshallingInfo<String> LANGUAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Language").isBinary(false).build();
    private static final CreateScriptRequestModelMarshaller INSTANCE = new CreateScriptRequestModelMarshaller();

    private CreateScriptRequestModelMarshaller() {
    }

    public static CreateScriptRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateScriptRequest createScriptRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createScriptRequest), (String)"createScriptRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(createScriptRequest.dagNodes(), DAGNODES_BINDING);
            protocolMarshaller.marshall(createScriptRequest.dagEdges(), DAGEDGES_BINDING);
            protocolMarshaller.marshall((Object)createScriptRequest.languageAsString(), LANGUAGE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

