/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.glue.model.Crawler;
import software.amazon.awssdk.services.glue.transform.CrawlerTargetsUnmarshaller;
import software.amazon.awssdk.services.glue.transform.LastCrawlInfoUnmarshaller;
import software.amazon.awssdk.services.glue.transform.ScheduleUnmarshaller;
import software.amazon.awssdk.services.glue.transform.SchemaChangePolicyUnmarshaller;

public class CrawlerUnmarshaller
implements Unmarshaller<Crawler, JsonUnmarshallerContext> {
    private static final CrawlerUnmarshaller INSTANCE = new CrawlerUnmarshaller();

    public Crawler unmarshall(JsonUnmarshallerContext context) throws Exception {
        Crawler.Builder crawlerBuilder = Crawler.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    crawlerBuilder.name((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Role", targetDepth)) {
                    context.nextToken();
                    crawlerBuilder.role((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Targets", targetDepth)) {
                    context.nextToken();
                    crawlerBuilder.targets(CrawlerTargetsUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("DatabaseName", targetDepth)) {
                    context.nextToken();
                    crawlerBuilder.databaseName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Description", targetDepth)) {
                    context.nextToken();
                    crawlerBuilder.description((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Classifiers", targetDepth)) {
                    context.nextToken();
                    crawlerBuilder.classifiers(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("SchemaChangePolicy", targetDepth)) {
                    context.nextToken();
                    crawlerBuilder.schemaChangePolicy(SchemaChangePolicyUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("State", targetDepth)) {
                    context.nextToken();
                    crawlerBuilder.state((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("TablePrefix", targetDepth)) {
                    context.nextToken();
                    crawlerBuilder.tablePrefix((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Schedule", targetDepth)) {
                    context.nextToken();
                    crawlerBuilder.schedule(ScheduleUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("CrawlElapsedTime", targetDepth)) {
                    context.nextToken();
                    crawlerBuilder.crawlElapsedTime((Long)context.getUnmarshaller(Long.class).unmarshall((Object)context));
                }
                if (context.testExpression("CreationTime", targetDepth)) {
                    context.nextToken();
                    crawlerBuilder.creationTime((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("LastUpdated", targetDepth)) {
                    context.nextToken();
                    crawlerBuilder.lastUpdated((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("LastCrawl", targetDepth)) {
                    context.nextToken();
                    crawlerBuilder.lastCrawl(LastCrawlInfoUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("Version", targetDepth)) {
                    context.nextToken();
                    crawlerBuilder.version((Long)context.getUnmarshaller(Long.class).unmarshall((Object)context));
                }
                if (context.testExpression("Configuration", targetDepth)) {
                    context.nextToken();
                    crawlerBuilder.configuration((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("CrawlerSecurityConfiguration", targetDepth)) {
                    context.nextToken();
                    crawlerBuilder.crawlerSecurityConfiguration((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Crawler)crawlerBuilder.build();
    }

    public static CrawlerUnmarshaller getInstance() {
        return INSTANCE;
    }
}

