/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glue.model.CrawlerMetrics;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CrawlerMetricsMarshaller {
    private static final MarshallingInfo<String> CRAWLERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CrawlerName").isBinary(false).build();
    private static final MarshallingInfo<Double> TIMELEFTSECONDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TimeLeftSeconds").isBinary(false).build();
    private static final MarshallingInfo<Boolean> STILLESTIMATING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StillEstimating").isBinary(false).build();
    private static final MarshallingInfo<Double> LASTRUNTIMESECONDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastRuntimeSeconds").isBinary(false).build();
    private static final MarshallingInfo<Double> MEDIANRUNTIMESECONDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MedianRuntimeSeconds").isBinary(false).build();
    private static final MarshallingInfo<Integer> TABLESCREATED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TablesCreated").isBinary(false).build();
    private static final MarshallingInfo<Integer> TABLESUPDATED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TablesUpdated").isBinary(false).build();
    private static final MarshallingInfo<Integer> TABLESDELETED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TablesDeleted").isBinary(false).build();
    private static final CrawlerMetricsMarshaller INSTANCE = new CrawlerMetricsMarshaller();

    private CrawlerMetricsMarshaller() {
    }

    public static CrawlerMetricsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CrawlerMetrics crawlerMetrics, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)crawlerMetrics, (String)"crawlerMetrics");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)crawlerMetrics.crawlerName(), CRAWLERNAME_BINDING);
            protocolMarshaller.marshall((Object)crawlerMetrics.timeLeftSeconds(), TIMELEFTSECONDS_BINDING);
            protocolMarshaller.marshall((Object)crawlerMetrics.stillEstimating(), STILLESTIMATING_BINDING);
            protocolMarshaller.marshall((Object)crawlerMetrics.lastRuntimeSeconds(), LASTRUNTIMESECONDS_BINDING);
            protocolMarshaller.marshall((Object)crawlerMetrics.medianRuntimeSeconds(), MEDIANRUNTIMESECONDS_BINDING);
            protocolMarshaller.marshall((Object)crawlerMetrics.tablesCreated(), TABLESCREATED_BINDING);
            protocolMarshaller.marshall((Object)crawlerMetrics.tablesUpdated(), TABLESUPDATED_BINDING);
            protocolMarshaller.marshall((Object)crawlerMetrics.tablesDeleted(), TABLESDELETED_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

