/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glue.model.BatchGetPartitionRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class BatchGetPartitionRequestModelMarshaller {
    private static final MarshallingInfo<String> CATALOGID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CatalogId").isBinary(false).build();
    private static final MarshallingInfo<String> DATABASENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DatabaseName").isBinary(false).build();
    private static final MarshallingInfo<String> TABLENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TableName").isBinary(false).build();
    private static final MarshallingInfo<List> PARTITIONSTOGET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PartitionsToGet").isBinary(false).build();
    private static final BatchGetPartitionRequestModelMarshaller INSTANCE = new BatchGetPartitionRequestModelMarshaller();

    private BatchGetPartitionRequestModelMarshaller() {
    }

    public static BatchGetPartitionRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(BatchGetPartitionRequest batchGetPartitionRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)batchGetPartitionRequest), (String)"batchGetPartitionRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)batchGetPartitionRequest.catalogId(), CATALOGID_BINDING);
            protocolMarshaller.marshall((Object)batchGetPartitionRequest.databaseName(), DATABASENAME_BINDING);
            protocolMarshaller.marshall((Object)batchGetPartitionRequest.tableName(), TABLENAME_BINDING);
            protocolMarshaller.marshall(batchGetPartitionRequest.partitionsToGet(), PARTITIONSTOGET_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

