/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glue.model.BatchDeleteTableRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class BatchDeleteTableRequestModelMarshaller {
    private static final MarshallingInfo<String> CATALOGID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CatalogId").isBinary(false).build();
    private static final MarshallingInfo<String> DATABASENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DatabaseName").isBinary(false).build();
    private static final MarshallingInfo<List> TABLESTODELETE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TablesToDelete").isBinary(false).build();
    private static final BatchDeleteTableRequestModelMarshaller INSTANCE = new BatchDeleteTableRequestModelMarshaller();

    private BatchDeleteTableRequestModelMarshaller() {
    }

    public static BatchDeleteTableRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(BatchDeleteTableRequest batchDeleteTableRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)batchDeleteTableRequest), (String)"batchDeleteTableRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)batchDeleteTableRequest.catalogId(), CATALOGID_BINDING);
            protocolMarshaller.marshall((Object)batchDeleteTableRequest.databaseName(), DATABASENAME_BINDING);
            protocolMarshaller.marshall(batchDeleteTableRequest.tablesToDelete(), TABLESTODELETE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

