/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.glue.transform.UpdateGrokClassifierRequestMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateGrokClassifierRequest
implements StructuredPojo,
ToCopyableBuilder<Builder, UpdateGrokClassifierRequest> {
    private final String name;
    private final String classification;
    private final String grokPattern;
    private final String customPatterns;

    private UpdateGrokClassifierRequest(BuilderImpl builder) {
        this.name = builder.name;
        this.classification = builder.classification;
        this.grokPattern = builder.grokPattern;
        this.customPatterns = builder.customPatterns;
    }

    public String name() {
        return this.name;
    }

    public String classification() {
        return this.classification;
    }

    public String grokPattern() {
        return this.grokPattern;
    }

    public String customPatterns() {
        return this.customPatterns;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.classification());
        hashCode = 31 * hashCode + Objects.hashCode(this.grokPattern());
        hashCode = 31 * hashCode + Objects.hashCode(this.customPatterns());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateGrokClassifierRequest)) {
            return false;
        }
        UpdateGrokClassifierRequest other = (UpdateGrokClassifierRequest)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.classification(), other.classification()) && Objects.equals(this.grokPattern(), other.grokPattern()) && Objects.equals(this.customPatterns(), other.customPatterns());
    }

    public String toString() {
        return ToString.builder((String)"UpdateGrokClassifierRequest").add("Name", (Object)this.name()).add("Classification", (Object)this.classification()).add("GrokPattern", (Object)this.grokPattern()).add("CustomPatterns", (Object)this.customPatterns()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Classification": {
                return Optional.ofNullable(clazz.cast(this.classification()));
            }
            case "GrokPattern": {
                return Optional.ofNullable(clazz.cast(this.grokPattern()));
            }
            case "CustomPatterns": {
                return Optional.ofNullable(clazz.cast(this.customPatterns()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        UpdateGrokClassifierRequestMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String classification;
        private String grokPattern;
        private String customPatterns;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateGrokClassifierRequest model) {
            this.name(model.name);
            this.classification(model.classification);
            this.grokPattern(model.grokPattern);
            this.customPatterns(model.customPatterns);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getClassification() {
            return this.classification;
        }

        @Override
        public final Builder classification(String classification) {
            this.classification = classification;
            return this;
        }

        public final void setClassification(String classification) {
            this.classification = classification;
        }

        public final String getGrokPattern() {
            return this.grokPattern;
        }

        @Override
        public final Builder grokPattern(String grokPattern) {
            this.grokPattern = grokPattern;
            return this;
        }

        public final void setGrokPattern(String grokPattern) {
            this.grokPattern = grokPattern;
        }

        public final String getCustomPatterns() {
            return this.customPatterns;
        }

        @Override
        public final Builder customPatterns(String customPatterns) {
            this.customPatterns = customPatterns;
            return this;
        }

        public final void setCustomPatterns(String customPatterns) {
            this.customPatterns = customPatterns;
        }

        public UpdateGrokClassifierRequest build() {
            return new UpdateGrokClassifierRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateGrokClassifierRequest> {
        public Builder name(String var1);

        public Builder classification(String var1);

        public Builder grokPattern(String var1);

        public Builder customPatterns(String var1);
    }
}

