/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.glue.model.DataCatalogEncryptionSettings;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutDataCatalogEncryptionSettingsRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, PutDataCatalogEncryptionSettingsRequest> {
    private final String catalogId;
    private final DataCatalogEncryptionSettings dataCatalogEncryptionSettings;

    private PutDataCatalogEncryptionSettingsRequest(BuilderImpl builder) {
        super(builder);
        this.catalogId = builder.catalogId;
        this.dataCatalogEncryptionSettings = builder.dataCatalogEncryptionSettings;
    }

    public String catalogId() {
        return this.catalogId;
    }

    public DataCatalogEncryptionSettings dataCatalogEncryptionSettings() {
        return this.dataCatalogEncryptionSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataCatalogEncryptionSettings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutDataCatalogEncryptionSettingsRequest)) {
            return false;
        }
        PutDataCatalogEncryptionSettingsRequest other = (PutDataCatalogEncryptionSettingsRequest)((Object)obj);
        return Objects.equals(this.catalogId(), other.catalogId()) && Objects.equals(this.dataCatalogEncryptionSettings(), other.dataCatalogEncryptionSettings());
    }

    public String toString() {
        return ToString.builder((String)"PutDataCatalogEncryptionSettingsRequest").add("CatalogId", (Object)this.catalogId()).add("DataCatalogEncryptionSettings", (Object)this.dataCatalogEncryptionSettings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CatalogId": {
                return Optional.ofNullable(clazz.cast(this.catalogId()));
            }
            case "DataCatalogEncryptionSettings": {
                return Optional.ofNullable(clazz.cast(this.dataCatalogEncryptionSettings()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private String catalogId;
        private DataCatalogEncryptionSettings dataCatalogEncryptionSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(PutDataCatalogEncryptionSettingsRequest model) {
            super(model);
            this.catalogId(model.catalogId);
            this.dataCatalogEncryptionSettings(model.dataCatalogEncryptionSettings);
        }

        public final String getCatalogId() {
            return this.catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        public final DataCatalogEncryptionSettings.Builder getDataCatalogEncryptionSettings() {
            return this.dataCatalogEncryptionSettings != null ? this.dataCatalogEncryptionSettings.toBuilder() : null;
        }

        @Override
        public final Builder dataCatalogEncryptionSettings(DataCatalogEncryptionSettings dataCatalogEncryptionSettings) {
            this.dataCatalogEncryptionSettings = dataCatalogEncryptionSettings;
            return this;
        }

        public final void setDataCatalogEncryptionSettings(DataCatalogEncryptionSettings.BuilderImpl dataCatalogEncryptionSettings) {
            this.dataCatalogEncryptionSettings = dataCatalogEncryptionSettings != null ? dataCatalogEncryptionSettings.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutDataCatalogEncryptionSettingsRequest build() {
            return new PutDataCatalogEncryptionSettingsRequest(this);
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    CopyableBuilder<Builder, PutDataCatalogEncryptionSettingsRequest> {
        public Builder catalogId(String var1);

        public Builder dataCatalogEncryptionSettings(DataCatalogEncryptionSettings var1);

        default public Builder dataCatalogEncryptionSettings(Consumer<DataCatalogEncryptionSettings.Builder> dataCatalogEncryptionSettings) {
            return this.dataCatalogEncryptionSettings((DataCatalogEncryptionSettings)((DataCatalogEncryptionSettings.Builder)DataCatalogEncryptionSettings.builder().applyMutation(dataCatalogEncryptionSettings)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

