/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.SecurityGroupIdListCopier;
import software.amazon.awssdk.services.glue.transform.PhysicalConnectionRequirementsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PhysicalConnectionRequirements
implements StructuredPojo,
ToCopyableBuilder<Builder, PhysicalConnectionRequirements> {
    private final String subnetId;
    private final List<String> securityGroupIdList;
    private final String availabilityZone;

    private PhysicalConnectionRequirements(BuilderImpl builder) {
        this.subnetId = builder.subnetId;
        this.securityGroupIdList = builder.securityGroupIdList;
        this.availabilityZone = builder.availabilityZone;
    }

    public String subnetId() {
        return this.subnetId;
    }

    public List<String> securityGroupIdList() {
        return this.securityGroupIdList;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityGroupIdList());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PhysicalConnectionRequirements)) {
            return false;
        }
        PhysicalConnectionRequirements other = (PhysicalConnectionRequirements)obj;
        return Objects.equals(this.subnetId(), other.subnetId()) && Objects.equals(this.securityGroupIdList(), other.securityGroupIdList()) && Objects.equals(this.availabilityZone(), other.availabilityZone());
    }

    public String toString() {
        return ToString.builder((String)"PhysicalConnectionRequirements").add("SubnetId", (Object)this.subnetId()).add("SecurityGroupIdList", this.securityGroupIdList()).add("AvailabilityZone", (Object)this.availabilityZone()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SubnetId": {
                return Optional.ofNullable(clazz.cast(this.subnetId()));
            }
            case "SecurityGroupIdList": {
                return Optional.ofNullable(clazz.cast(this.securityGroupIdList()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PhysicalConnectionRequirementsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String subnetId;
        private List<String> securityGroupIdList = DefaultSdkAutoConstructList.getInstance();
        private String availabilityZone;

        private BuilderImpl() {
        }

        private BuilderImpl(PhysicalConnectionRequirements model) {
            this.subnetId(model.subnetId);
            this.securityGroupIdList(model.securityGroupIdList);
            this.availabilityZone(model.availabilityZone);
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final Collection<String> getSecurityGroupIdList() {
            return this.securityGroupIdList;
        }

        @Override
        public final Builder securityGroupIdList(Collection<String> securityGroupIdList) {
            this.securityGroupIdList = SecurityGroupIdListCopier.copy(securityGroupIdList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIdList(String ... securityGroupIdList) {
            this.securityGroupIdList(Arrays.asList(securityGroupIdList));
            return this;
        }

        public final void setSecurityGroupIdList(Collection<String> securityGroupIdList) {
            this.securityGroupIdList = SecurityGroupIdListCopier.copy(securityGroupIdList);
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public PhysicalConnectionRequirements build() {
            return new PhysicalConnectionRequirements(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PhysicalConnectionRequirements> {
        public Builder subnetId(String var1);

        public Builder securityGroupIdList(Collection<String> var1);

        public Builder securityGroupIdList(String ... var1);

        public Builder availabilityZone(String var1);
    }
}

